import React from 'react';

import FavouritesIcon from '../../../../svg-components/favourites.component.svg';
import { Star } from '../../../ui/Star';
import { IStore } from '../../App/store';
import { FavouritesLines } from '../../FavouritesLines';
import Spin from '../../Spin';
import { BASIC_MENUS_TRANSLATE } from '../constants';
import { _CHATS, ILinesListData, ISelectedMenus } from '../types';
import style from './style.css';

interface IMenuProps extends IStore {
    data: [string, ILinesListData];
    isLoading?: boolean;
    onMenuClick: (menu, submenu) => void;
    selectedItems: ISelectedMenus;
    onFavClick?: (el: any, menu: string) => void;
    title?: string;
}

export const BaseMenu = React.memo((props: IMenuProps) => {
    const { data, onMenuClick, selectedItems, title, isLoading } = props;
    const favLines = new FavouritesLines();

    const menu = data?.[0] as _CHATS;
    const lines = data?.[1]?.items;
    const totalCount = data?.[1]?.info?.totalItems || '';
    const isMenuSelected = selectedItems.menuItem === menu && !selectedItems.subMenuItem;

    const onFavClick = props.onFavClick
        ? (submenu, menu, e: KeyboardEvent) => {
            e.stopPropagation();
            props.onFavClick?.({
                name: submenu.name,
                display_name: submenu.display_name,
                chats_count: submenu.chats_count,
            }, menu);
        }
        : () => {};

    return <div className={style.menu_block}>
        <div onClick={onMenuClick.bind(null, menu, null)}
             id={style[menu]}
             className={`${style.interactive} ${style.menu_title_container}`
             + `${!totalCount && !lines?.length ? style.empty : ''} `
             + `${isMenuSelected ? style.selected : ''} `}>

            <Star size={'l'} className={`${style[menu]}`}/>
            <span>{BASIC_MENUS_TRANSLATE[menu] || title}</span>
            <strong>{totalCount}</strong>
            {isLoading && <span className={style.spinner}>
                <Spin size={'s'}/>
            </span>}
        </div>

        {lines?.length
            ? lines.map((submenu, ind) => {
                const chatsCount = submenu?.chats_count;
                const isImportant = favLines.match(menu, submenu.name);
                const title = submenu.display_name || submenu.name;
                const isSubMenuSelected = selectedItems.subMenuItem === submenu.name && selectedItems.menuItem === menu;

                return <div onClick={onMenuClick.bind(null, menu, submenu.name)}
                            className={`${style.menu_item} ${style.interactive} ${isSubMenuSelected ? style.selected : ''}`}
                            key={ind}>

                    <div onClick={onFavClick.bind(null, submenu, menu)}>
                        <LineMarker isImportant={isImportant} chatsCount={chatsCount || 0}/>
                    </div>

                    <span className={`${style.menu_item_title} ${isImportant ? style.bold : ''}`}
                          title={title}>
                        {title}
                    </span>

                    <span className={style.count}>
                        <span>{chatsCount}</span>
                    </span>
                </div>;
            })
            : null
        }
    </div>;
});

const LineMarker = React.memo((props: { isImportant: boolean; chatsCount: number }) => {
    return props.isImportant
        ? <FavouritesIcon className={style.fav_chats_icon}/>
        : <Star size={'s'} className={props.chatsCount ? style.chats_count : ''}/>;
});
