import React, { useState } from 'react';

import { Button, ButtonTypes } from '../../ui/Button';
import { Window } from '../../ui/FullModal';
import Select from '../../ui/Select';
import { Request2 } from '../../utils/request';
import { deepCopy } from '../../utils/utils';
import { getTagId } from './chatUtils';
import style from './index.css';
import { requestConfigs, REQUESTS } from './request';

interface IMigrateButtonProps {
    options: any[];
    chatItem: any;
    updateChatItemTag?: (chatItem: any, tag: any) => void;
}

export const MigrateButton = (props: IMigrateButtonProps) => {
    const request = new Request2({ requestConfigs });

    const [error, setError] = useState();
    const [isLoading, setIsLoading] = useState(false);
    const [selectedQueue, setSelectedQueue] = useState();
    const [isMigrateWindowOpen, openMigrateWindow] = useState(false);

    function migrateChat() {
        setIsLoading(true);

        request.exec(REQUESTS.TAG_EVOLVE, {
            queryParams: {
                tag_id: getTagId(props.chatItem),
            },
            body: {
                tag: selectedQueue,
                priority: 0,
                is_problem_solved: false,
                topic_link: props.chatItem?.topic_link ?? props.chatItem?.id,
                object_id: props.chatItem?.originator,
            },
        })
            .then(() => {
                if(props?.updateChatItemTag) {
                    const tagData = deepCopy(props.chatItem.tag_data);
                    tagData.tag = selectedQueue;
                    props.updateChatItemTag(props.chatItem, tagData);
                }

                setIsLoading(false);
                openMigrateWindow(false);
            })
            .catch(error => {
                setIsLoading(false);
                setError(error);
            });
    }

    return <>
        <Button isLoading={isLoading}
                onClick={openMigrateWindow.bind(null, true)}
                colorType={ButtonTypes.positive}
                basic={true}>
            Перенести в другую очередь
        </Button>

        {isMigrateWindowOpen
            ? <Window onClose={openMigrateWindow.bind(null, false)}
                      error={error}
                      title={`Перенос в другую очередь`}>

                <Select options={props.options}
                        multiSelect={false}
                        disabled={isLoading}
                        className={style.migrate_select}
                        onSelect={setSelectedQueue.bind(null)}
                        placeholder={'Очередь'}/>

                <Button onClick={migrateChat.bind(null)}
                        disabled={!selectedQueue}
                        isLoading={isLoading}>
                    Перенести
                </Button>

            </Window>
            : null
        }
    </>;
};
