type ICgiParser = [string | null, string | null, string | null]

export const cgiParser = (location): ICgiParser => {
    const params = location && location.search && new URLSearchParams(location.search);

    return params && [params.get('user_id'), params.get('chat_id'), params.get('performer_id')]
        || [null, null, null];
};

export const getTagId = (item) => {
    return item?.tag_id || item?.tag_data?.tag_id || null;
};

export const getHrefTagId = (location): string => {
    const params = location?.search && new URLSearchParams(location.search);

    return params?.get('tag_id') ?? '';
};
