import * as React from 'react';

import { EMPTY_DATA } from '../../constants';
import LS from '../../utils/localStorage/localStorage';
import { NAVIGATION } from '../../utils/navigation';
import * as style from './index.css';

const randomColorStyle = () => {
    const listStatus: string[] = [
        style.positive,
        style.negative,
        style.negative_light,
        style.warning,
        style.info,
        style.party,
    ];

    return listStatus[Math.floor(Math.random() * listStatus.length)];
};

export const LabelTag = React.memo((props: { label; className?: string }) => {
    return <div title={props.label}
                className={`${style.label_tag} ${style.ellipsis}`
        + ` ${randomColorStyle()} ${props.className ? props.className : ''}`}>
        {props.label ? props.label : EMPTY_DATA}
    </div>;
});

export class MessagesByTopic extends LS {
    _messages = {};
    _key = `${this.name}_mbt`;

    _getAll() {
        let data = localStorage.getItem(this._key);
        if (!data) {
            data = '{}';
            localStorage.setItem(this._key, data);
        }

        try {
            this._messages = JSON.parse(data);
        } catch (e) {
            this._messages = {};
        }

        return this._messages;
    }

    constructor() {
        super();
        this._getAll();
    }

    remove(id) {
        const data: any = this._getAll();
        delete data[id];
        localStorage.setItem(this._key, JSON.stringify(data));
    }

    setText(props: { text: string; id: string }) {
        const data: any = this._getAll();
        if (!data.hasOwnProperty(props.id)) {
            data[props.id] = '';
        }

        data[props.id] = props.text;
        localStorage.setItem(this._key, JSON.stringify(data));
    }

    getText(id: string) {
        const data: any = this._getAll();

        return data[id] || null;
    }
}

export const chatLink = (selectedChat: any, isDispatcher?: boolean, tag_id?: string) => {
    const uri = isDispatcher ? NAVIGATION.ROUTES?.OUTGOING?.uri : NAVIGATION?.ROUTES?.CHATS?.uri;
    const chat_id = isDispatcher ? selectedChat.topic_link : selectedChat?.id;
    const tagId = tag_id ? `&tag_id=${tag_id}` : '';

    return `${location.origin}${location.pathname}#/${uri}`
        + `?user_id=${selectedChat?.originator}&chat_id=${chat_id}` + tagId;
};

export const formatMigrateOptions = (data, evolutions) => {
    const tags = {};

    data?.records?.forEach(tag => {
        tags[tag.name] = tag;
    });

    return evolutions?.map(evol => {
        const tag = tags[evol.to] ?? {};

        return {
            text: tag.display_name || tag.name,
            value: evol.to,
            description: tag.comment,
        };
    });
};
