import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_USER_INFO = 'GET_USER_INFO',
    GET_USER_SESSIONS = 'GET_USER_SESSIONS',
    DEFER = 'DEFER',
    EDIT_MESSAGE = 'EDIT_MESSAGE',
    SESSION_HISTORY = 'SESSION_HISTORY',
    UPLOAD_RESOURCE = 'UPLOAD_RESOURCE',
    REGISTER_RESOURCE = 'REGISTER_RESOURCE',
    SEND_MESSAGE = 'SEND_MESSAGE',
    SET_PERFORM = 'SET_PERFORM',
    TAG_EVOLVE = 'TAG_EVOLVE',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/info',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_SESSIONS]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            user_id: null,
        },
    },
    [REQUESTS.DEFER]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'request/defer',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.EDIT_MESSAGE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message/edit',
    },
    [REQUESTS.SESSION_HISTORY]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            ts_since: null,
            user_id: null,
            car_id: null,
            session_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.UPLOAD_RESOURCE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/resource',
        cgiObj: {
            chat_id: null,
            resource_id: null,
            user_id: null,
        },
    },
    [REQUESTS.REGISTER_RESOURCE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },
    [REQUESTS.SEND_MESSAGE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message',
        cgiObj: {
            user_id: null,
            chat_id: null,
        },
    },
    [REQUESTS.SET_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/start',
    },
    [REQUESTS.TAG_EVOLVE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'tag/evolve',
        cgiObj: {
            tag_id: null,
        },
    },
};
