import { MinimalUserInfo } from '../../models/user';
import { MESSAGE_TYPE } from '../Chats/types';

// eslint-disable-next-line @typescript-eslint/no-namespace
export namespace NChats {
    export interface IQueue {
        user_id: string;
        chat_id: string;
        tag?: string;
        tag_id?: string;
        tag_display_name?: string;
    }

    export interface ITree {
        [key: string]: IQueue[];
    }

    export enum MenuItemType {
        MY_CHATS = 'my_chats',
        NEW_CHATS = 'new_chats',
        All_CHATS = 'all_chats',
        DEFER = 'defer_chats',
        ARCHIVE = 'archive_chats',
        CUSTOM_CHATS = 'custom_chats',
    }

    export interface IMenuItem {
        menuItem: string;
        type: MenuItemType;
        queue: IQueue[];
    }

    export interface ITopicMessageItem {
        'type': MESSAGE_TYPE;
        'text': string;
        cached_images?: string[];
        cached_previews?: string[];
        traits?: string[];
        content_types?: string[];
        'author': string;
        'id': number;
        'timestamp': number;

        link?: string; //image_link
        icon?: string; //image_link

        bg_link?: string; //for bonus?
        external_status?: string;
    }

    export interface IExpectedAction {
        'type': string;
        'text': string;
    }

    export interface ICategory {
        category: {
            id: string;
            meta: {
                call_direction: string;
                enabled: boolean;
                keyword: string[];
                label: string;
                order: number;
                origins: string[];
            };
        };
        comment: string;
        id: string;
        operator_id: string;
        timestamp: number;
        meta_info: any;
    }

    export interface IChatListItem {
        id: string;
        originator: string;
        tag_data: any;
        tag_id: string;
        tag_performer_id: string;
        last_message: ITopicMessageItem;
        name: string;
        icon: string;
        stats: {
            total: number;
            unread: number;
        };
        categorization?: {
            tag_id: string;
            items: ICategory[];
        };
    }

    export enum MESSAGE_TYPE {
        WELCOME_TEXT = 'welcome_text',
        PLAINTEXT = 'plaintext',
        ORDER = 'order',
        STICKER = 'sticker',
        LOCATION = 'location',
        CREDIT_CARD = 'CreditCardBinding',
        BONUS = 'bonus',
        SEPARATOR = 'separator',
        MEDIA_RESOURCES = 'media_resources',
        SENDING = 'sending',
        SENDING_RESOURCE = 'sending_resource'
    }

    export enum CHATS_COMMAND {
        INIT_CHECKING_QUEUE = 'INIT_CHECKING_QUEUE',
        START_CHECKING_QUEUE = 'START_CHECKING_QUEUE',
        FINISH_CHECKING_QUEUE = 'FINISH_CHECKING_QUEUE',
        UPDATE_WORKER_IS_READY = 'UPDATE_WORKER_IS_READY',
        SET_CHATS = 'SET_CHATS',
        SET_CHATS_LOADING = 'SET_CHATS_LOADING'
    }

    export interface ISelectedChatData {
        expected_action?: {
            type: ExpectedActionType;
            text: string;
        };
        messages: IMessage[];
        user_last_viewed: number;
        users: Record<string,MinimalUserInfo>;
    }
}

export enum ExpectedActionType {
    tree = 'tree',
    user_message = 'user_message',
    chat_closed = 'chat_closed'
}

export enum NOTIFY_PERMISSION {
    denied = 'denied',
    default = 'default',
    granted = 'granted'
}

export enum _CHATS {
    MY = 'my_chats',
    ALL = 'all_chats',
    NEW = 'new_chats',
    DEFFER = 'defer_chats',
    ARCHIVE = 'archive_chats',
    CUSTOM = 'custom_chats',
}

export enum ADDITIONAL_CONTROL_TYPES {
    UPDATE_BUTTON = 'UPDATE_BUTTON',
}

export interface ISelectedMenus {
    menuItem: string | null;
    subMenuItem: string | null;
}

export interface ILineInfo {
    name: string;
    display_name: string;
    chats_count: number;
}

export interface ILinesListData {
    info: {
        totalItems: number;
    };
    items: ILineInfo[];
}

export type LinesMenuType = {
    [key in _CHATS]: ILinesListData
};

export interface IAdditionalControl {
    type: ADDITIONAL_CONTROL_TYPES;
    onClick: any;
    item?: any;
    state?: any;
}

export interface IAdditionalMenu {
    type: _CHATS;
    title: string;
    onClick: () => void;
    showSubmenu?: boolean;
    submenuData?: any;
}

export interface IMessageBase {
    author: string;
    id: number;
    text: string;
    timestamp: number;
    type: MESSAGE_TYPE;
    traits?: string[];
}

export interface IMessageBonus extends IMessageBase {
    bg_link: string;
    bg_width: number;
    bg_height: number;
}

export interface IMessageImageLink extends IMessageBase {
    link: string;
    icon: string;
}

export interface IMediaMessage extends IMessageBase {
    cached_images: string[];
    cached_previews: string[];
    content_types: string[];
}

export type IMessage = IMessageBase & IMessageBonus & IMediaMessage & IMessageImageLink
