import * as React from 'react';

import { isObjectEqual } from '../../../../utils/isObjectEqual';
import * as style from '../../index.css';

interface IBadgeItemProps {
    url: string;
    title?: string;
    onClick?: any;
    className?: string;
    rowClassName?: string;
    enabled?: boolean;
}

const checkMemoProps = (prevProps, nextProps) => {
    return isObjectEqual(prevProps, nextProps);
};

export const BadgeItem = React.memo((props: IBadgeItemProps) => {
    const { url, title, onClick, className = '', enabled, rowClassName = '' } = props;

    return <div className={`${style.wrap_achievements_item} ${style[className]} ${!enabled ? style.disabled : ''} ${onClick ? style.interactive : ''}`}>
        <div className={`${style.achievements_item}` + `${rowClassName ? ` ${rowClassName}` : ''}`}
             onClick={onClick && onClick}
             title={title}
             style={{ backgroundImage: `url(${url})` }}/>
    </div>;
}, checkMemoProps);

export class BadgeContainer extends React.Component<any, any> {
    render() {
        return <div className={`${style.achievements_2}`}>
            {this.props.children}
        </div>;
    }
}
