import * as React from 'react';

import { Window } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import * as style from '../index.css';
import { CLIENTS_CARD_REQUESTS as requestConfigs, REQUESTS } from '../request';
import { BadgeContainer, BadgeItem } from './Badge';

interface IAchievements2State {
    admin_icons: AchievementData[];
    showMoreAchievements: boolean;
    isLoading: boolean;
    loadingError: Error | null;
}

interface IAchievements2Props {
    user_id: string;
    additionalsAchievements?: React.ReactNode[];
    plus: boolean;
    vip: boolean;
    ya: boolean;
}

interface AchievementData {
    action_meta: {
        admin_icon: string;
    };
    action_description: string;
    enabled: boolean;
    action_id: string;
}

const PLUS_URL = 'data:image/svg+xml;base64,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';
const YA_URL = 'https://carsharing.s3.yandex.net/admin/achievement/ya.png';
const MORE_URL = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKXSURBVGhD7ZZJyE1hGIB/ZCYzmSWSjTJlQ0JJhsQCGxtSslCKwspQimJlzEayEpJZyYaFoaREiUSZCQuU2fN83dP9O/8597/XUu9Tz+J9v/c7937nm05TEARBEARBEARBENRFexyMA7GtiQbpiENxQIoapzOOwD4p+gf88cP4Cf9UfI07sQe2xlg8jl8x6/8UN2MnbI0peAm/Y9b/Pq7GdlgXk/Ed2vk3PsPnlVgf4UgsYx5+QWt/4hN8W4n1FvbCMlah/ax1II/xQyXWs9gBa9IXsx89gcMxYxxeR9vuossujzORDWI/+ryMqfgAbbtgooAZ6CB0C3ZHcVnPxRdo/wNYE5eOheexjYkcXfAeWrPSRA6Xk237UtSSfugStWamiRw30bb1KWrJGHS5OtDRJspw2figiSkqZila42Cb43RnP+IfLsN9Yv+9KaoyBM2/x6LZzjiE1m1IUQk/8BcWzUbGKPRBD1NUZRia92XUYhZadzlFVaaj+SspKmcFWncwRSV8Rou6paiY8WjNnRRV6Y/m3WO1WIzWnUxRFQ8Z87dTVM46tG5Pikq4ihYtT1Ex29AapziPR6xtbuwyjqE1G1NUxf2XLc3mh0yea2j/ZSkqwUaL3qBLKM809FTyWJ5gIscmtL+nkzOUZwna12d40eZxudjfF1q0KjwEbH+JXU2U4d44jRZ7Ge7AObgA3Zzf0LZdWISX3Q205hU6sNm4CI+i+8+2NViEx7X3hjXutbXonvKAOYPmnbH52Cr+mSPom7Njcz0MtmOtz5XeeBHzfdWlUzaIDA8NL82i/h/Rl9IQk3A3nkPfxlb0HK8XLzfvEy+/U+ieGIT14ItaiH4m+ani/eTs9MQgCIIgCIIgCIIg+P9pavoLWBG3ImGgY+cAAAAASUVORK5CYII=';
const VIP = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAB7CAAAewgFu0HU+AAAAB3RJTUUH4wMHES8KaV6Z0QAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAPz0lEQVR42u1de1hTRxY/MRBCEBQSIETkESILUl6lCFRhRWAVly6CJYrKWle31hakW63bp4jWR2V11bRW7PqgglpStRZ3BRVZRCC8C4JFHiGS8AjyEDSSVEL2j6IVIckkJOkS7+/78kFyz8yZe34zZ+bMnZmLh0kOHx8fPxKJtMTMzGwumUwm7dmzR3Dp0qVhwKBbtLS0EMUcwidiDoEv5hCkYg5BJuYQ+sUcwqGVK1faTtb7wk3Wgos5hJ0A8JGcy1+n1x7etG7dugeT7b6mTDSDFStWmLu5uUU4Ojq+bW9v/4aTk1NAUlISSZuFdnd3DweAeAUia7dt2xanzTKsWrXKxMXFxV/MIUSLOYQYd3f3oNTUVNJvymZISIi3mENgizkE8YjLkIo5hF4xh3Dc1dXVTVt6aTRa0og+RZ/zixYtMtKGfl9f3wAxh5Axcq+PRz79Yg7h6OLFi+1/kxayb98+43/vLNgIAK8DgNEz+ZkDwJqqE80fhoaGTtOGQVLi78sQxMyrqqoMNK07JiZmRgGr+lMAWDFyrwYjHzMA+Ov5rdc2ymQynM4JycjIeAUA/qRAZCmXyw3RBiFbj9mUAMCAIhnHKHKVUCgUaVp3aWnpQgBYqEBkmbe3t4fOCRkYGHAfqSHyQBSJRF7aIMTf378YACoViHTOmDHjojZ03/m2w02J3aj379/30jkh29e2Wygbpd292EfWhlEyMjIGAKBZkd2Cg4MrNa03MzMTDwCmSsTwEomEpnNCooOHJAhiEtAeFJX9AY/He6RphUwmUwoAQ8rkZDLZY50T4h5n3wwAChXToymD2mAiNjaWAgAuirqQvr4+a23opkdTlNlMbGxsfEfnhHh5eRUAQI4iGalU6rZ582YnTRulsLAwCgBeUSDi2tTU9Lqm9W7atMmEe77bTolYlqWlZf5vEqnPmjUr8Napu5sB4A8AQJQjlu2ynHaEx+NppJMNCAjwzftnxUEACFAiWjP3Hfd3KioqbmpCb3R0tP3pLZfeBoAt8twkAGTF7Yv8gs1mF/9mUyexsbGUoqKieRKJxJ/3fW+QHEN1nrtu8FUHYfvhzZs3d6ura+/evdSNQZ/sB4BYxCTsHVnvb9q5cyd/Ivdob28ffefbjvUjFe953KZHU7LMzc3zZs+efYPNZk/ITWt0LsvPz29W/sGqHQCwbLzrx34wzDxb8PLBgoKCIjUj9D3c891/VyWN01LLlLa2ti1qBoGOHA5nQyNbuAYAKOON5hivWyUKBIIcTdlQ45OLDAYjoja9NWMkch03tpq9wvYgl8s9rUq+M2fOXN3IFrIQhp3P45Ezk5rY2tr6L1USzZ49O6byeNM6Oa3iCXYS/X/+RFdDR7Xg4uLCAQBFo4w5t08LDpzeTfr4888/RzLu/Pnz5zayhRvVIAMAgNSQ2Rk/Z86cQBThd999l06j0XZXHm/6SgkZ/R5/driuafvhNZ1hQ0PDI4cZRE+PWcNzFIiZuDoOB/s75FG/zaff7e3tFcoTTEpKmp664UyyEuMoA3VNeKcx//Gq3OrqarFc9+bktORCUu6nicserQEAZTO3zdk/eu9vbm5++H/dQgAAPkuzLEUIoHAA8Jdbp+4eZTAYa8vLyw3HE/odMSUeAJZroFjLUzeciZfTV1Ctra2312XwvwaAcJTMTlwyrFy7dm2XLqNdtTFt2rQKAOhEFJ9Tm9566KWhV78ICgoa5VacnZ2Z0cFDiRrs6xIZDEbMsz+4ubm9dmrTxX/dvdj3qZyOe9xgfMfxaSUjkfv/t8sCAFi6dOngQs/KEABADQoNAcAnLkwQwrA3smkXeT90cHAgc47c3gYArhosGunt6H7Kf+sDyphMJp7L5b7305m2rUqCzPHQdzLbJqW7u7tN07bT2iNcMYewAwDUHYF0AIAQALy0VLyLI5UxQs305Qv/HhCen5/fPSlcFgCA1xv0EgAQq5ncRotkAABEToAMAIBybZChVUJMTExqAOAu6B9krrEzKrSVudYIiYiIaAeACj0k5B6ZTJ58hCQnJw85RpFLAECmZ4TUT58+nTvpCAEAoFAopQDQp2eEVF67dq1/UhJiZWXVCIoftU42DDkzqVp1w1olJDc3t8dhiUWpHhEinDp1auWkJQQAgEAgcEDJo95JhIaQkBDBpCbE1NS0YiTI0weUs1isgUlNyIIFC9oAoEEPyHjsHmdfqW0lWieExWINnL1qUK4HhHSamZn9OOkJAQDYk2FXpQf9yJ2R1q5VGOjiTohEYgUAtAGAw2RlwzGKXNTRkfJAL1pIZGRkMwBcmMzROYVCuawLRTrbQRUYGDjzakrJBgDwf65lSgGg/3mXZh9pDoaGhoDH40EikUh43/f2j8iOgsMSC5gyZQrseLMfVi6S6xXNXJbTTKRSKUilUvhodT+sixwjO3ULi2iyN+HpBLUR/LLWrIEeTfmuvb39W70i5Ak8PDxMAACsra3Bw8MDqFQqJAR+LAYAiNsX+VQuJiZm1F8cDqf20zmZTIYHAGCz2U9/e/L/qU2/rN/bfflDw4cPH+KFQiHU1NQAkUjEu7m5GXG53Af5+fliwIABAwYMGDBgwIABAwYMGHQWqRM+ECOtDPl5DxGnCX0owbUWZxVkGi6rJnX+MqdEyl1/zFhwReHUhKGhYe0/MjPx6i4wDg0NpdXX18dLpVKFe9cJBEK/l5cX6+LFi0+3ofn5+c3n8/nLJ3JkBQCATCbrJ5PJrLq6OoVb3BgMRoRIJHpNIzUehwMcDic0NTUtDQoKKjh69Gi/xlqId97vnUtKShrVKZidnV1c54qGb1BkffKD3YuLi2uffKfT6W8JmLe/0lR1VdbSUe2hKqbcq75Hzo5+q62t7bxcGVUy7OnpCVKnIJmZmfgez48SX/T+YdjS0/JeXPM5wgdiWVFRkfGECbn/2Dh05HgJlbBr1y76Y7c3fJD9qIGBSN/JCdtbfyUvL484LiG4+9wmlEwGYsuWHzhwwEFV5d3d3b9XRb6goKBF3wl57LJiXvgJKBiXEEZBzArUjIRC4VxVFL/55puGXauavkaVZ/zwcuQL48JoAa+4urouG0PIggULalAz6XTbEp+UlITs6mpqalyQOz1hZZ+Pj0/hi9SvtDqu3x4XF0ceRQiLxZKYfjf/PaSmNnu175UrV2aiKhQIBMjuatp/olJOnTrV8yIR8tjjLefr168vHtOp25lKslAzaW9vD0CRS0hIMOpa1cRSYWh89UUcfd1bWnw4ISHBaBQhdQuLG+HRPaRlLh1LClNR5EpLS19CdlfdtZ3e3t7VL+R4mGQ1NTc31+lppP4kWJo5cyZTuLJR+eoKY4rZ3Llz7QoLC1sVifH5/GDUMlnmRH1wlM8fd9mIqakp17D2ePVjeoTTszeBFozVdA2bUEkAAPieulbLgvURrRq0pUHThXFd7BAjSqXT9Pr7+30A4PaohXJUKvWGEN1t+QFAq4LRFemkxaEUFdxVHp8//oxGdXX1lRjnvFzoyAMAgKqqKoPW12uRVoLMb9v6qqmpKe/Jd3Zrq8b2lntcmxfp5+c37iCk7Po/Z9V4HD4/THnJBiUvEXX+QmjLODWKkLKysk5Kt/+hgWWcjUpjC8dVa6FlB1ve9bKyMk+FZ3c+A/MT9vsLhUKFFZfNZkufmdoYQjWaRCIZys7OlmrD0/T29vZ8+eWX8gYhPUnhWf5HjvxxV9+auyuVlpOxNPDgn+cYjRm+muEGfkC60TkfL1y0aJGtgngF+YhYMzMznawK1DWSk5NbXVxcvkCRlToutjtz5ozJGEICAwORt2y1tLT4jfd7YmLi9L55Bzeg5hMYGFiir/11fn4+x7D+NNKpdkNDQ2MJSUtLu2/QfPE/iB3R/PF+z8nJ8ZTSX0M6KtXipMN7x48ffwB6jGmlnyC1EoFAMGXciNul+fOtSD70DV58aGjoGMN3mvqvRC2sra2t3sceMplMgGhP3riErF69uhYedSGdA8Xn80cd3BIREUF5FHLkryhpjTjb8lNSUur1nRAikWiMHI/J6QMkVudf/RtKBsKprzCf/V5fX/8yqnJq27nU4ODgIX0nRCwWI83nueUEOMidJHRwQDu+7lHYsZUBAQFWT8fTIlEYakEtLCyu6zsZqamphj2rW1iILWlQLiE3b97kGpV8huTfe3p6fAAAwsLCrHqXFiYgdua7SkpKhPpOyP79+5EfJzg5OYkUTqNb888izVnx/Q7vAgBoamryk02lIb1ExdLSMlvfyQgMDAzie3x2CEl4sHsgPT1dZKDEaAUo8z7SGfO8wsLCrG44piAN76bcq74XEBBQcevWrUltcAHz9k2CguvVNzY3Djm9hjR1Yn0+YCsflDxTLy4u7rI46bAbJcOurq4/yixc7FBkba4v33706NFH+t5CxEH/mIUqa2NjUwmAsMiBTCYj9SOtUtv3UZXT6fQrgGEU7O3tawAQtkUvWLCgoknUOSgzoSocS4siziEdVonr+UmQm5vbgFHwK0zZgR+zm8v6kVoIi8UaMGf7a+w4bZurUe9gFIzGbBrxjMLA8HnY2dnlakq5k5NTIUbBr6CddUl8dtkTEiHh4eE/4e9eaZqocqt0RlJubm4PRsMvMLydVr53797jSqdOnkdycvLPlJvv7NRAx4V15r8Gxjl/wGevYzKZD1UmBADA1tY2byIFwPNyuEwmswqjAsDw1td1vr6+2y5cuDBmUQcyIcXFxXdxvfVqv6nG/MaGHYmJiZIXnQzKN/SDy6k/LsnKyuKMGzSrkplt7tJ4tUdXNjbXX2QipnTXdtLOuixpa2v727Fjx+T2xyodz2Rra1ukThMhXV17uqKiolXvjX6vpmvY0sPKqOSzK4AnDJrePlJBIpG6LS0tq52dnSvTeDwxDqd4z5HKO5Io9Jf3DDCLVHoP1O/+7bv41q1bai9kiIiIsKurq/N88n14eNigI/bOecTO81MDA4MWIpE4IJPJHpibm4vKy8vLFKVB3bATVB4xg8fjPQwPD4fLly9LEhIS4P2O9eIPjXbjk5OTh9W5V5UJcXZ2nsuLrkF+FR1O1Dm4fCCJlpaWdl9dQuh0+noB8/YRTdZmRbuoUAmJbI4zeHZ5kkZamaoJPD09VToI0rDxO/ZEyFC34kxat6dqAjabPWh+wn4jcu1u/yYFMGiPEAAAGo12Dal11J2siIqKqsfMjA61DsFkMBgNdQhy1nV79ydncYcwM2u5hbDZbCk5zVHhNjjcw3YJnU7/L2ZiHbQQAAArK6sbimYJLb8POnBNIGjHTKyDFgIAUF1d3QaDPXJPJSCTydmYeXVICACA1Tm/ZfKuubu7l2Hm1TEhnp6epXhezpjX/1BPO8enp6drbPM/Ho/X6YIIQvWXJ5XJkK7+5SxWfTBgwIABAwYMGDBgUAv/A8gJnRpcew12AAAAAElFTkSuQmCC';
const limit_count = 15;

export class Achievements2 extends React.Component<IAchievements2Props, IAchievements2State> {
    state: IAchievements2State = {
        admin_icons: [],
        showMoreAchievements: false,
        isLoading: false,
        loadingError: null,
    };
    request = new Request2({
        requestConfigs,
    });

    componentDidMount(): void {
        this.props.user_id && this.getActions(this.props);
    }

    componentDidUpdate(prevProps: Readonly<IAchievements2Props>) {
        if (prevProps.user_id !== this.props.user_id && this.props.user_id !== null) {
            this.getActions(this.props);
        }
    }

    componentWillUnmount() {
        this.request.abort();
    }

    getActions(props: IAchievements2Props) {
        this.setState({ isLoading: true }, () => {
            this.request.exec(REQUESTS.GET_USER_ACTIONS, { queryParams: { user_id: props.user_id } })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        loadingError: null,
                        admin_icons: response.actions
                            && response.actions.reduce((_p: any, _c: any) => {
                                if (_c.hasOwnProperty('action_meta') && _c.action_meta.admin_icon) {
                                    _p.push(_c);
                                }

                                return _p;
                            }, []) || [],
                    });
                })
                .catch((loadingError) => {
                    this.setState({ loadingError, isLoading: false });
                });
        });

    }

    showMore() {
        this.setState({
            showMoreAchievements: true,
        });
    }

    onClose() {
        this.setState({
            showMoreAchievements: false,
        });
    }

    render() {
        const icons = this.state.admin_icons.slice(0, limit_count);
        const additionals: any[] = [];
        if (this.props.ya) {
            additionals.push(<AchievementsModalItem key={'Ya'}
                                                    item={{
                                                        action_meta: { admin_icon: YA_URL },
                                                        action_description: 'Яндексоид',
                                                        action_id: 'Яндексоид',
                                                        enabled: true,
                                                    }}/>);
        }

        if (this.props.plus) {
            additionals.push(<AchievementsModalItem key={'Plus'}
                                                    item={{
                                                        action_meta: { admin_icon: PLUS_URL },
                                                        action_description: 'Я.Плюс',
                                                        action_id: 'plus',
                                                        enabled: true,
                                                    }}/>);
        }

        if (this.props.vip) {
            additionals.push(<AchievementsModalItem key={'call_priority'}
                                                    item={{
                                                        action_meta: { admin_icon: VIP },
                                                        action_description: 'ВИП',
                                                        action_id: 'call_priority',
                                                        enabled: true,
                                                    }}/>);
        }

        return <BadgeContainer>
            {this.state.isLoading
                ? <>
                    {new Array(limit_count).fill('').map((item: any, index) => {
                        return <div key={index} className={style.fake_achievement_item}/>;
                    })}
                </>
                : <>
                    {
                        this.props.ya && <BadgeItem title={'Яндексоид'}
                                                    enabled={true}
                                                    className={style.plus}
                                                    url={YA_URL}/>
                    }
                    {
                        this.props.plus && <BadgeItem title={'Plus'}
                                                      enabled={true}
                                                      className={style.plus}
                                                      url={PLUS_URL}/>
                    }
                    {
                        this.props.vip && <BadgeItem enabled={true}
                                                     title={style.call_priority}
                                                     url={VIP}/>
                    }
                    {
                        icons
                            .map((_el, index) => <BadgeItem key={index}
                                                            url={_el.action_meta.admin_icon}
                                                            enabled={_el.enabled}
                                                            title={_el.action_description || _el.action_id}/>)
                    }
                    {
                        (icons.length || this.props.vip || this.props.plus)
                        && <BadgeItem onClick={this.showMore.bind(this)}
                                      title={'more'}
                                      enabled={true}
                                      className={style.more}
                                      url={MORE_URL}/>
                        || null
                    }
                    {
                        this.state.showMoreAchievements
                        && <AchievementsModal data={this.state.admin_icons}
                                              additionalsAchievements={additionals}
                                              onClose={this.onClose.bind(this)}/>
                    }
                </>}
        </BadgeContainer>;
    }
}

const AchievementsModal = (props: {
    data: AchievementData[];
    onClose: () => void;
    additionalsAchievements?: React.ReactNode[];
}) => {

    return <Window onClose={props.onClose}>
        <div className={style.more_achievements_modal}>
            <h2>Achievements: actions</h2>
            <div className={style.container_wrapper}>
                <div className={style.container}>
                    {
                        props.additionalsAchievements && props.additionalsAchievements.map((item) => item)
                    }
                    {
                        props.data.map((item, index) => {
                            return <AchievementsModalItem key={index} item={item}/>;
                        })
                    }
                </div>
            </div>
        </div>
    </Window>;
};

const AchievementsModalItem = (props: { item: AchievementData }) => {
    const icon = props.item && props.item.action_meta && props.item.action_meta.admin_icon;
    const enabled = props.item && props.item.enabled;

    return <div className={`${style.achievements_modal__item} ${!enabled ? style.disabled : ''}`}
                title={props.item.action_description}>
        <div className={style.achievements_modal__item_url} style={{ backgroundImage: `url(${icon})` }}/>
        <div className={style.achievements_modal__item_id}>{props.item.action_id}</div>
    </div>;
};
