import * as React from 'react';

import { Confirm } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { IAccount } from '../../Settings/Wallets/types';
import { CLIENTS_CARD_REQUESTS, REQUESTS } from '../request';

interface IBillingViewActivateModalProps {
    account: IAccount;
    onClose: () => void;
    reloadData: () => void;
}

interface IBillingViewActivateModalState {
    isWorking: boolean;
    error: Error | null;
}

export class BillingViewActivateModal extends
    React.Component<IBillingViewActivateModalProps, IBillingViewActivateModalState> {
    state: IBillingViewActivateModalState = {
        isWorking: false,
        error: null,
    };

    request = new Request2({ requestConfigs: CLIENTS_CARD_REQUESTS });

    setActive(account) {
        const { reloadData, onClose } = this.props;

        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.ACTIVATE_ACCOUNT, {
                body: {
                    account_id: account.id,
                    active_flag: !account.is_active,
                },
            })
                .then(() => {
                    reloadData();
                    onClose();
                })
                .catch((error) => {
                    this.setState({
                        isWorking: false,
                        error,
                    });
                });
        }) ;
    }

    render() {
        const { account, onClose } = this.props;
        const { isWorking, error } = this.state;

        const question = account.is_active ? `Заблокировать кошелёк ${account.name || account.id}?`
            : `Разблокировать кошелёк ${account.name || account.id}?`;

        return (
            <Confirm onClose={onClose.bind(this)}
                     question={question}
                     isWorking={isWorking}
                     error={error}
                     accept={this.setActive.bind(this, account)}/>
        );
    }
}
