import * as React from 'react';
import ReactTooltip from 'react-tooltip';

import { NoInformation } from '../../../../../ui/NoInformation';
import * as tblStyle from '../../../../../ui/Table/index.css';
import { isTest } from '../../../../../utils/utils';
import styles from '../../index.css';
import { IBillingCurrentTask } from '../../types';
import { BillingCurrentTask } from '../BillingCurrentTask';

interface IBillingCurrentTableProps {
    userId: string;
    filteredData: IBillingCurrentTask[];
    reloadData: () => void;
    className?: string;
    areAllExpanded: boolean;
    showNotAuthorized?: boolean;
}

const billingCurrentTooltipId = 'billing-current';

export const BillingCurrentTable = (props: IBillingCurrentTableProps) => {
    const { userId, filteredData, reloadData, areAllExpanded, showNotAuthorized = true } = props;

    return !filteredData?.length ? <NoInformation/> : (
        <>
            {!isTest() && <ReactTooltip id={billingCurrentTooltipId}
                                        effect="solid"
                                        html>
            </ReactTooltip>}
            <table className={`${tblStyle.table} ${tblStyle.clearBackground} ${tblStyle.clearFirstOpacity} ${styles.table}`}>
                <thead>
                    <tr>
                        <th/>
                        <th>Тип списания</th>
                        <th>Сумма</th>
                        <th>Депозит</th>
                        <th>Статус</th>
                        <th>Обновилось</th>
                        <th colSpan={2}>{}</th>
                    </tr>
                </thead>
                <tbody>
                    {filteredData.map((billingTask, index) => {
                        return (
                            <BillingCurrentTask task={billingTask}
                                                key={index}
                                                showNotAuthorized={showNotAuthorized}
                                                areAllExpanded={areAllExpanded}
                                                reloadData={reloadData}
                                                userId={userId}
                                                externalTooltipId={billingCurrentTooltipId}/>
                        );
                    })}
                </tbody>
            </table>
        </>
    );
};
