import * as React from 'react';

import * as styles from '../index.css';
import { BillingNotAuthorizedFilter } from '../NotAuthorizedFilter';
import { IBillingCurrentTask } from '../types';
import { BillingCurrentTable } from './BillingCurrentTable';

interface IBillingViewCurrentProps {
    userId: string;
    data: IBillingCurrentTask[];
    currentFilter?: string;
    reloadData: () => void;
    className?: string;
    additionalTitle?: string;
}

interface IBillingViewCurrentState {
    areAllExpanded: boolean;
}

export class BillingViewCurrent extends React.Component<IBillingViewCurrentProps, IBillingViewCurrentState> {
    state: IBillingViewCurrentState = {
        areAllExpanded: false,
    };

    expand(e) {
        e.stopPropagation();
        this.setState({
            areAllExpanded: !this.state.areAllExpanded,
        });
    }

    render() {
        const { data, currentFilter, reloadData, className, additionalTitle, userId } = this.props;
        const { areAllExpanded } = this.state;

        const filteredData = data?.filter((task) => {
            return currentFilter ? task.billing_type === currentFilter : true;
        }) ?? [];

        return <div className={className}>
            <div className={styles.tableHeader}>
                <h4>Текущие списания {additionalTitle}</h4>
                {filteredData?.length
                    ? <div className={`${styles.expandToggle} ${styles.expandToggleTable}`}
                           onClick={this.expand.bind(this)}>
                        {areAllExpanded ? 'Свернуть таблицу' : 'Развернуть таблицу'}
                    </div>
                    : null
                }
            </div>
            <BillingNotAuthorizedFilter showFilter={!!filteredData?.length}>
                <BillingCurrentTable filteredData={filteredData}
                                     userId={userId}
                                     areAllExpanded={areAllExpanded}
                                     reloadData={reloadData}/>
            </BillingNotAuthorizedFilter>
        </div>;
    }
}
