import { mount } from 'enzyme';
import * as React from 'react';

import BillingViewCurrent from './index';

const data = [{ "last_status_update":1618365717,"meta":{ "max_yandex_bonus":14647017,"real_session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","accounts":["bonus","card"],"offer_name":"cheap_base_offer_builder_2","use_only_selected_paymethod":false,"offer_type":"standart_offer","is_plus_user":true },"cashback":0,"exec_context":{ "last_update":1618365717 },"payments":[{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"793630","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1247422","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1616759986","payment_id":"16f6412da2acbc1e95c5031b117059a2","wait_refund":0,"created_at_ts":"1616490854","order_id":"141107664","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"737211","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1248325","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1616827011","payment_id":"fb7fc2a6127a207306d94192bb53a6a9","wait_refund":0,"created_at_ts":"1616567795","order_id":"141158354","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"187087","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1249178","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1616903935","payment_id":"cf6a37c7e3de7056d4344796c562a36d","wait_refund":0,"created_at_ts":"1616644724","order_id":"141218989","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"311617","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1249979","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1616980870","payment_id":"8102d2075303dd6645ca661987cc264f","wait_refund":0,"created_at_ts":"1616721652","order_id":"141295899","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"582079","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1250846","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617057823","payment_id":"93c8a4d762f3c42485ec2704d83be7fb","wait_refund":0,"created_at_ts":"1616798589","order_id":"141363313","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"545032","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1252075","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617179290","payment_id":"2f8d3a756272bb78041c661f38ce6b41","wait_refund":0,"created_at_ts":"1616875531","order_id":"141391109","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"860724","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1252373","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617211664","payment_id":"92367c00a33df9a124140116ef30911a","wait_refund":0,"created_at_ts":"1616952455","order_id":"141419496","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"479037","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1252817","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617288618","payment_id":"f350d3ff734d51ff36aa0280da71b3ed","wait_refund":0,"created_at_ts":"1617029407","order_id":"141463434","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"102838","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1253372","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617365613","payment_id":"292172cf52c7a59257279708fc1be091","wait_refund":0,"created_at_ts":"1617106362","order_id":"141517011","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"505593","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1254058","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617442496","payment_id":"360ba0306219b9aaf605af8012bf468b","wait_refund":0,"created_at_ts":"1617183281","order_id":"141591171","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"644774","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1254624","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617519421","payment_id":"6fa08e3a13be933d472a1e818d67ba9d","wait_refund":0,"created_at_ts":"1617260205","order_id":"141650131","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"586984","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1255252","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617596334","payment_id":"f97f2e7f633665bc14b41b8197dc9413","wait_refund":0,"created_at_ts":"1617337123","order_id":"141690438","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"150794","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1255820","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617673270","payment_id":"59829989c32a1484c6a59109a3d20f54","wait_refund":0,"created_at_ts":"1617414058","order_id":"141744567","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"461680","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1256198","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617750236","payment_id":"2772f61ef2a6840cc4b16101322bab49","wait_refund":0,"created_at_ts":"1617491023","order_id":"141770508","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"713173","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1256642","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617827174","payment_id":"7e253476f3cc7af82782621fb278cefc","wait_refund":0,"created_at_ts":"1617567955","order_id":"141795944","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"303965","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1257166","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617904096","payment_id":"8a30f286127779aea7b98310c4b154ae","wait_refund":0,"created_at_ts":"1617644875","order_id":"141855756","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"53526","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1257816","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1617981024","payment_id":"3c91055933442eb8660558854ab7b82e","wait_refund":0,"created_at_ts":"1617721810","order_id":"141903720","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"989445","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1258362","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1618057966","payment_id":"d120fe08223c7029f79aea0a92a5fadd","wait_refund":0,"created_at_ts":"1617798753","order_id":"141947304","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"141566","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1258974","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1618134893","payment_id":"e625d58a82cd77f066bb728212160394","wait_refund":0,"created_at_ts":"1617875677","order_id":"141992757","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"66150","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1259595","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1618211851","payment_id":"f1e7d1921304b7802646d189dae21393","wait_refund":0,"created_at_ts":"1617952629","order_id":"142078356","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"389152","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1267416","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1618288756","payment_id":"283af331c3260edcb504ff0d79c389cd","wait_refund":0,"created_at_ts":"1618029543","order_id":"142142263","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"710843","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1269784","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"31415","status":"cleared","last_update_ts":"1618365717","payment_id":"64eba7e703a4d4daa570071f8f6eea68","wait_refund":0,"created_at_ts":"1618106505","order_id":"142177596","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"443638","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1259353","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"0","status":"authorized","last_update_ts":"1618183433","payment_id":"0bb6a6b583818d7286d31f80d7f4822a","wait_refund":0,"created_at_ts":"1618183427","order_id":"142218639","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"958924","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1264410","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"0","status":"authorized","last_update_ts":"1618260353","payment_id":"5620a796d2495f9db7c95e1170d323d7","wait_refund":0,"created_at_ts":"1618260349","order_id":"142279422","payment_type":"card","payment_error_desc":"" },{ "user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","payment_error":"","sum":"31415","account_id":"0","rrn":"578041","pay_method":"card-x55a40927ca8278e84324d7c0","billing_type":"car_usage","id":"1269585","session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","card_mask":"510000****9768","meta":"{\"cashback_percent\":0}","refunded":0,"cleared":"0","status":"authorized","last_update_ts":"1618337279","payment_id":"79996377c248cb5714a83a83bc7403d6","wait_refund":0,"created_at_ts":"1618337274","order_id":"142345142","payment_type":"card","payment_error_desc":"" }],"task_status":"ok","bill":808270,"next_queue":"active","event_id":68250058,"discretization":31415,"session_id":"bc0be24d-b6f366c6-c93b460b-a5dbefa6","state":"active","user_id":"35c85a28-61c3-480e-9b8b-0842b4d19787","billing_type":"car_usage","last_payment_id":1269784,"queue":"active","deposit":0 }];

describe('BillingViewCurrent', () => {
    it('should display all data with required-only props', () => {
        const component = mount(
            <BillingViewCurrent data={data}
                                reloadData={jest.fn()}
                                userId={'1087a921-5bbb-49c7-aaae-0e1c6170073d'}/>,
        );

        expect(component).toMatchSnapshot();
    });

    it('should display all data with required-only props and empty data', () => {
        const component = mount(
            <BillingViewCurrent data={[]}
                                reloadData={jest.fn()}
                                userId={'1087a921-5bbb-49c7-aaae-0e1c6170073d'}/>,
        );

        expect(component).toMatchSnapshot();
    });

    it('should display all data with all props', () => {
        const component = mount(
            <BillingViewCurrent additionalTitle={'(test)'}
                                currentFilter={'ticket_gibdd'}
                                data={data}
                                reloadData={jest.fn()}
                                userId={'1087a921-5bbb-49c7-aaae-0e1c6170073d'}/>,
        );

        expect(component).toMatchSnapshot();
    });
});
