import * as React from 'react';

import { Confirm } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { IAccount } from '../../Settings/Wallets/types';
import { CLIENTS_CARD_REQUESTS, REQUESTS } from '../request';

interface IBillingViewDeleteModalProps {
    user_id: string;
    account: IAccount;
    onClose: () => void;
    reloadData: () => void;
}

interface IBillingViewDeleteModalState {
    isWorking: boolean;
    error: Error | null;
}

export class BillingViewDeleteModal extends
    React.Component<IBillingViewDeleteModalProps, IBillingViewDeleteModalState> {
    state: IBillingViewDeleteModalState = {
        isWorking: false,
        error: null,
    };

    request = new Request2({ requestConfigs: CLIENTS_CARD_REQUESTS });

    removeAccount() {
        const { account, onClose, reloadData, user_id } = this.props;
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.LINK_WALLET_USER, {
                body: {
                    account_id: account.id,
                    action: 'unlink',
                    user_id,
                } })
                .then(() => {
                    reloadData.call(null);
                    onClose();
                })
                .catch((error) => {
                    this.setState({
                        isWorking: false,
                        error,
                    });
                });
        });
    }

    render() {
        const { onClose, account } = this.props;
        const { isWorking, error } = this.state;

        return (
            <Confirm onClose={onClose.bind(this)}
                     question={`Удалить кошелёк ${account.name || account.id}?`}
                     isWorking={isWorking}
                     error={error}
                     accept={this.removeAccount.bind(this)}/>
        );
    }
}
