import * as React from 'react';
import ReactTooltip from 'react-tooltip';

import { NoInformation } from '../../../../../ui/NoInformation';
import tblStyle from '../../../../../ui/Table/index.css';
import { IBlockRules } from '../../../../../utils/IBlockRules';
import { isTest } from '../../../../../utils/utils';
import styles from '../../index.css';
import { IBillingHistoryTask, ITags } from '../../types';
import { BillingHistoryTask } from '../BillingHistoryTask';

interface IBillingHistoryTableProps extends IBlockRules {
    tags?: ITags;
    filteredData: IBillingHistoryTask[];
    userId: string;
    areAllExpanded: boolean;
    reloadData: () => void;
    showNotAuthorized?: boolean;
}

const billingHistoryTooltipId = 'billing-history';

export const BillingHistoryTable = (props: IBillingHistoryTableProps) => {
    const { tags, filteredData, userId, BlockRules, areAllExpanded, reloadData, showNotAuthorized = true } = props;
    const [formattedTags, setFormattedTags] = React.useState({});

    React.useEffect(() => {
        const formattedTags = tags?.records?.reduce((_p: any, _c: any) => {
            if (!_p.hasOwnProperty(_c.tag_id)) {
                _p[_c.tag_id] = {};
            }

            if (!_p[_c.tag_id].hasOwnProperty(_c.action)) {
                _p[_c.tag_id][_c.action] = _c;
            }

            return _p;
        }, {}) ?? {};
        setFormattedTags(formattedTags);
    }, [tags?.records]);

    return <>
        {
            !isTest() && <ReactTooltip id={billingHistoryTooltipId}
                                       type="info"
                                       effect="solid"
                                       html>
            </ReactTooltip>
        }
        {filteredData?.length
            ? <table className={`${tblStyle.table} ${tblStyle.clearBackground}` +
                ` ${tblStyle.clearFirstOpacity} ${styles.table}`}>
                <thead>
                    <tr>
                        <th>#</th>
                        <th colSpan={2}/>
                        <th>Тип списания</th>
                        <th>Счет</th>
                        <th>Сессия</th>
                        <th colSpan={2}>Когда</th>
                    </tr>
                </thead>
                <tbody>
                    {filteredData?.map((billingTask, index) => {
                        return (
                            <BillingHistoryTask tags={formattedTags}
                                                userId={userId}
                                                task={billingTask}
                                                key={index}
                                                index={index}
                                                showNotAuthorized={showNotAuthorized}
                                                areAllExpanded={areAllExpanded}
                                                reloadData={reloadData}
                                                externalTooltipId={billingHistoryTooltipId}
                                                BlockRules={BlockRules}/>
                        );
                    })}
                </tbody>
            </table>
            : <NoInformation/>
        }
    </>;
};
