import * as React from 'react';

import styles from '../index.css';
import { BillingNotAuthorizedFilter } from '../NotAuthorizedFilter';
import { IBillingHistoryTask, ITags } from '../types';
import BillingHistoryTable from './BillingHistoryTable';

interface IBillingViewHistoryProps {
    data: IBillingHistoryTask[];
    timelapse?: string;
    currentFilter?: string;
    reloadData: () => void;
    userId: string;
    tags?: ITags;
}

interface IBillingViewHistoryTableState {
    areAllExpanded: boolean;
}

export class BillingViewHistory extends React.Component<IBillingViewHistoryProps, IBillingViewHistoryTableState> {
    state: IBillingViewHistoryTableState = {
        areAllExpanded: false,
    };

    expand(e) {
        e.stopPropagation();
        this.setState({
            areAllExpanded: !this.state.areAllExpanded,
        });
    }

    render() {
        const { tags, data, timelapse, currentFilter, reloadData, userId } = this.props;
        const { areAllExpanded } = this.state;

        const filteredData = data?.filter((task) => {
            return currentFilter ? task.billing_type === currentFilter : true;
        }) ?? [];

        return (
            <>
                <div className={styles.tableHeader}>
                    <h4>Завершенные списания {timelapse}</h4>
                    {filteredData?.length
                        ? <div className={`${styles.expandToggle} ${styles.expandToggleTable}`}
                               onClick={this.expand.bind(this)}>
                            {areAllExpanded ? 'Свернуть таблицу' : 'Развернуть таблицу'}
                        </div>
                        : null
                    }
                </div>
                <BillingNotAuthorizedFilter showFilter={!!filteredData?.length}>
                    <BillingHistoryTable tags={tags}
                                         filteredData={filteredData}
                                         userId={userId}
                                         areAllExpanded={areAllExpanded}
                                         reloadData={reloadData}/>
                </BillingNotAuthorizedFilter>
            </>
        );
    }
}
