import * as React from 'react';

import Checkbox from '../../../../ui/Checkbox';
import styles from './index.css';

interface IBillingNotAuthorizedFilterProps {
    showNotAuthorizedByDefault?: boolean;
    showFilter?: boolean;
}

export const BillingNotAuthorizedFilter = (props: React.PropsWithChildren<IBillingNotAuthorizedFilterProps>) => {
    const { showNotAuthorizedByDefault = true, children, showFilter } = props;
    const [showNotAuthorized, onChange] = React.useState(showNotAuthorizedByDefault);

    const childrenWithProps = React.cloneElement(children as React.ReactElement, { showNotAuthorized });

    return <>
        {showFilter
            ? <div className={styles.checkbox}>
                <Checkbox checked={showNotAuthorized}
                          onChange={onChange}/>
                <span>
                    Показывать платежи со статусом not_authorized
                </span>
            </div>
            : undefined
        }
        {childrenWithProps}
    </>;
};
