import * as React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../../constants';
import { CopyIcon } from '../../../../../ui/CopyIcon';
import FormatDate from '../../../../../ui/FormatDate';
import { Link } from '../../../../../ui/Link';
import { rubs } from '../../../../../utils/rubs';
import { Copy } from '../../../../Copy';
import { AccountType, PaymentStatus } from '../../../../Settings/Wallets/types';
import { IPaymentTask } from '../../types';
import * as styles from '../index.css';

interface ITrPaymentProps {
    index: number;
    payment: IPaymentTask;
    externalTooltipId: string;
    style: any;
    isTestingBackend?: boolean;
}

export const PaymentRow = React.memo((props: ITrPaymentProps) => {
    const { index, payment, externalTooltipId, style, isTestingBackend } = props;
    const receiptLink = isTestingBackend
        ? `https://trust-test.yandex.ru/checks/${payment.payment_id}/receipts/${payment.payment_id}?mode=mobile`
        : `https://trust.yandex.ru/checks/${payment.payment_id}/receipts/${payment.payment_id}?mode=pdf`;

    const MOBILE_PAYMENT = 'mobile_payment';
    const YA_BANK_MARK = 'yabank_card';
    const YA_BANK_DESC = 'Счет в Яндексе';

    const isYaBank = payment.meta?.includes(YA_BANK_MARK);

    return (
        <div className={`${styles.paymentRow}`
            + ` ${payment.status === PaymentStatus.CANCELED || payment?.refunded > 0 ? styles.refunded : ''}`}
             style={style}>
            <span>{index + 1}</span>
            <span>
                <span>{payment.payment_type}</span>
                <span>
                    {payment.rrn
                        ? <Copy className={styles.details} externalTooltipId={externalTooltipId}>{payment.rrn}</Copy>
                        : EMPTY_DATA}
                </span>
                <span>
                    {isYaBank
                        ? YA_BANK_DESC
                        : payment.card_mask && payment.payment_type !== MOBILE_PAYMENT
                            ? <Copy className={styles.details} externalTooltipId={externalTooltipId}>
                                {payment.card_mask}
                            </Copy>
                            : EMPTY_DATA
                    }
                </span>
                <CopyIcon text={payment.payment_id}
                          externalTooltipId={externalTooltipId}/>
                <Link href={`https://scrooge.paysys.yandex-team.ru/payments/?purchase_token=${payment.payment_id}`}
                      target={'_blank'}>
                    Скрудж
                </Link>
            </span>
            <span>
                <span>
                    {rubs(payment.sum)}/{rubs(payment.cleared)}
                </span>
                <span>
                    {rubs(payment.refunded)}/{rubs(payment.wait_refund)}
                </span>
            </span>
            <span>
                <FormatDate value={+payment.created_at_ts * ONE_SECOND}
                            withSecond={true}/>
            </span>
            <span>
                <FormatDate value={+payment.last_update_ts * ONE_SECOND}
                            withSecond={true}/>
            </span>
            <span>
                {payment.status === PaymentStatus.CANCELED ? (
                    <span className={styles.status_canceled}>{payment.status}</span>
                ) : <span className={styles.status}>{payment.status}</span>}
                {payment?.payment_error_desc?.length
                    ? <span className={`${styles.status} ${styles.payment_error}`}>{payment.payment_error_desc}</span>
                    : null}
            </span>
            <span>
                {payment?.user_id
                    ? <Link target={'_blank'}
                            href={`#/clients/${payment.user_id}`}>
                        пользователь, с которого списали
                    </Link>
                    : null
                }
            </span>
            <span>
                {payment.payment_type !== AccountType.BONUS && payment.status !== PaymentStatus.NOT_AUTHORIZED && (
                    <Link href={receiptLink}
                          target={'_blank'}>
                        чек
                    </Link>
                )}
            </span>
        </div>
    );
});
