import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import * as tblStyle from '../../../../ui/Table/index.css';
import LS from '../../../../utils/localStorage/localStorage';
import { IPaymentTask } from '../types';
import { PaymentRow } from './PaymentRow/component';

interface ITablePayments {
    shouldShow: boolean;
    externalTooltipId: string;
    payments: IPaymentTask[];
}

const MAX_HEIGHT = 460;
const ITEM_HEIGHT = 90;
const ITEM_PADDING = 2;

export const TablePayments = (props: ITablePayments) => {
    const { shouldShow, payments, externalTooltipId } = props;
    const isTestingBackend = (new LS()).envIsTesting();

    return (
        <tr className={tblStyle.noTrHover}>
            <td colSpan={9}>
                {shouldShow && <VirtualList height={payments?.length * (ITEM_PADDING + ITEM_HEIGHT) < MAX_HEIGHT
                    ? payments?.length * (ITEM_PADDING + ITEM_HEIGHT)
                    : MAX_HEIGHT
                }
                                            itemSize={ITEM_HEIGHT}
                                            itemCount={payments?.length}
                                            renderItem={({ index, style }) => {
                                                return <PaymentRow isTestingBackend={isTestingBackend}
                                                                   style={style}
                                                                   externalTooltipId={externalTooltipId}
                                                                   payment={payments[index]}
                                                                   key={index}
                                                                   index={index}/>;
                                            }}/>}
            </td>
        </tr>
    );
};
