import { TagRecord } from '../../../models/tag';
import { PaymentStatus } from '../../Settings/Wallets/types';

export enum BillingType {
    ticket = 'ticket',
    gibdd = 'ticket_gibdd',
    car_usage = 'car_usage',
    fueling = 'fueling',
    service = 'service'
}

export interface ITags {
    records?: TagRecord[];
}

export interface IBillingHistoryTask {
    timestamp: number;
    billing_type: BillingType;
    meta: {
        real_session_id: string;
    };
    bill: number;
    payments: IPaymentTask[];
    session_id: string;
}

export interface IBillingCurrentTask {
    last_status_update: number;
    meta: {
        max_yandex_bonus?: number;
        session_finish_time?: number;
        real_session_id?: string;
        cashback_percent?: number;
        accounts: any[];
        use_only_selected_paymethod: boolean;
        is_plus_user?: boolean;
        max_bonus?: number;
        offer_name?: string;
        offer_type?: string;
    };
    cashback: number;
    exec_context: {
        last_update: number;
    };
    payments: IPaymentTask[];
    task_status: string;
    bill: number;
    next_queue: string;
    event_id: number;
    discretization: number;
    session_id: string;
    state: string;
    user_id: string;
    billing_type: BillingType;
    last_payment_id: number;
    queue: string;
    deposit: number;
}

export interface IPaymentTask {
    payment_error: string;
    sum: string;
    account_id: string;
    rrn: string;
    pay_method: string;
    billing_type: string;
    id: string;
    session_id: string;
    card_mask: string;
    meta: string;
    refunded: number;
    cleared: string;
    status: PaymentStatus;
    last_update_ts: string;
    payment_id: string;
    wait_refund: number;
    created_at_ts: string;
    order_id: string;
    payment_type: string;
    payment_error_desc: string;
    user_id?: string;
}
