import * as React from 'react';

import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../../../models/session';
import { Link } from '../../../../ui/Link';
import { IBlockRules } from '../../../../utils/IBlockRules';
import { OfferDetails } from '../../../SessionCard/SessionCardHeader';
import { OfferInfoTooltip } from '../../SessionView/component';
import * as styles from './index.css';

interface ICCOfferInfo extends IBlockRules {
    sessions: SessionsHistoryItem | null;
    index: number;
}

export const CCOfferInfo = (props: ICCOfferInfo) => {
    const { sessions, index, BlockRules } = props;
    const current_offer = SessionHistoryInfoHandler.getCurrentOffer.call(sessions, index);
    const offer_proto = SessionHistoryInfoHandler.getOffer.call(sessions, index);
    const total = SessionHistoryInfoHandler.getTotalPrice.call(sessions, index);
    const [isDetailsOpen, openDetails] = React.useState(false);

    return (
        <div className={styles.session_offer}>
            <strong className={styles.total}>
                Итого: {total} <Link onClick={openDetails.bind(null, true)}>Детали тарифа</Link>
            </strong>
            <div>
                <b>Оффер:</b> {SessionHistoryInfoHandler.getOfferName.call(sessions, index)} (&nbsp;
                <OfferInfoTooltip BlockRules={BlockRules}
                                  current_offer={current_offer}
                                  offer_proto={offer_proto}
                                  total={total}
                                  index={index.toString()}
                                  showBaseName/>&nbsp;)
            </div>
            <div>
                <b>Тариф</b>: поездка <b>{SessionHistoryInfoHandler.getRideCost.call(sessions, index)}</b> |
                ожидание <b>{SessionHistoryInfoHandler.getParkingCost.call(sessions, index)}</b>
            </div>
            {isDetailsOpen && <OfferDetails data={SessionHistoryInfoHandler.getOfferDetails.call(sessions, index)}
                                            onClose={openDetails.bind(null, false)}/>}
        </div>
    );
};
