import * as React from 'react';

import { Dict } from '../../../../../types';
import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../../../models/session';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { SessionBadges } from '../../../SessionsList/SessionItem/badges';
import * as styles from './index.css';

interface ICCRouteInfo {
    sessions: SessionsHistoryItem | null;
    index: number;
    tagsObject: Dict<any>;
}

export const CCRouteInfo = (props: ICCRouteInfo) => {
    const { sessions, index, tagsObject } = props;
    const sessionId = SessionHistoryInfoHandler.getSessionId.call(sessions, index);

    return (
        <div className={styles.route_info}>
            <p>
                Начало:&nbsp;
                <FormatDate className={styles.date}
                            withSecond
                            value={SessionHistoryInfoHandler.getStart.call(sessions, index)}/>
            </p>
            <p>
                Конец:&nbsp;
                <FormatDate className={styles.date}
                            withSecond
                            value={SessionHistoryInfoHandler.getFinish.call(sessions, index)}/>
            </p>
            <div className={styles.controls}>
                <Link className={styles.link}
                      href={`#/session/${sessionId}?back=${encodeURIComponent(location.hash)}`}>
                    Подробней
                </Link>
                <Link className={styles.link}
                      href={`#/tracks?session_id=${sessionId}&status=`}>
                    Маршрут
                </Link>
                {
                    sessions
                    && <SessionBadges sessionsData={sessions} index={0} tagsObject={tagsObject} internalTooltip/>
                }
            </div>
        </div>
    );
};
