import React from 'react';

import { Dict } from '../../../../../types';
import { CAR_ACTIONS, SCOOTER_ACTIONS } from '../../../../models/car';
import { ButtonTypes } from '../../../../ui/Button';
import { QuickActionButton } from '../../../../ui/QuickActionButton';
import LS from '../../../../utils/localStorage/localStorage';
import { buttonLocationDetails, buttonNameDetails } from '../../../../utils/sendLogs/eventTypes/buttonDetails';
import * as styles from './index.css';

interface ISidebarButtonsProps {
    BlockRules: Dict<boolean>;
    questionDetails?: string | React.ReactElement;
    manageHood?: boolean;
    carControlHandle: (action: typeof CAR_ACTIONS | typeof SCOOTER_ACTIONS) => void;
}

export const SidebarButtons = React.memo((props: ISidebarButtonsProps) => {
    const ls = new LS();
    const { BlockRules, carControlHandle, questionDetails = '', manageHood } = props;
    const isSupportFull = BlockRules?.supportFull;
    const isScooterEnv = ls.envIsScooter();

    return <div className={styles.table}>
        {isSupportFull && !isScooterEnv
            ? <>
                <p className={styles.title}>Двери</p>
                <div className={styles.button_container}>
                    <QuickActionButton question={<div>Открыть машину? {questionDetails}</div>}
                                       button={{
                                           children: 'Открыть',
                                           colorType: ButtonTypes.negative,
                                           basic: true,
                                       }}
                                       showConfirm
                                       accept={carControlHandle.bind(null, CAR_ACTIONS.OPEN_DOORS)}
                                       ytLog={{
                                           button_name: buttonNameDetails.OPEN_DOORS,
                                           location: buttonLocationDetails.CLIENT_CARD,
                                       }}/>
                    <QuickActionButton question={<div>Закрыть машину? {questionDetails}</div>}
                                       button={{
                                           children: 'Закрыть',
                                           basic: true,
                                       }}
                                       showConfirm
                                       accept={carControlHandle.bind(null, CAR_ACTIONS.CLOSE_DOORS)}
                                       ytLog={{
                                           button_name: buttonNameDetails.CLOSE_DOORS,
                                           location: buttonLocationDetails.CLIENT_CARD,
                                       }}/>
                </div>

                {manageHood
                    ? <>
                        <p className={styles.title}>Капот</p>
                        <div className={styles.button_container}>
                            <QuickActionButton question={<div>Открыть капот? {questionDetails}</div>}
                                               button={{
                                                   children: 'Открыть',
                                                   colorType: ButtonTypes.negative,
                                                   basic: true,
                                               }}
                                               showConfirm
                                               accept={carControlHandle.bind(null, CAR_ACTIONS.YADRIVE_UNLOCK_HOOD)}
                                               ytLog={{
                                                   button_name: buttonNameDetails.OPEN_HOOD,
                                                   location: buttonLocationDetails.CLIENT_CARD,
                                               }}/>
                            <QuickActionButton question={<div>Закрыть капот? {questionDetails}</div>}
                                               button={{
                                                   children: 'Закрыть',
                                                   basic: true,
                                               }}
                                               showConfirm
                                               accept={carControlHandle.bind(null, CAR_ACTIONS.YADRIVE_LOCK_HOOD)}
                                               ytLog={{
                                                   button_name: buttonNameDetails.CLOSE_HOOD,
                                                   location: buttonLocationDetails.CLIENT_CARD,
                                               }}/>
                        </div>
                    </>
                    : null
                }
            </>
            : null
        }

        {isScooterEnv && isSupportFull
            ? <>
                <p className={styles.title}>Колесо</p>
                <div className={styles.button_container}>
                    <QuickActionButton question={'Разблокировать колесо?'}
                                       button={{
                                           children: 'Разблок.',
                                           colorType: ButtonTypes.negative,
                                           basic: true,
                                       }}
                                       showConfirm
                                       accept={carControlHandle.bind(null, SCOOTER_ACTIONS.OPEN_DOORS)}
                                       ytLog={{
                                           button_name: buttonNameDetails.OPEN_DOORS,
                                           location: buttonLocationDetails.CLIENT_CARD,
                                       }}/>
                    <QuickActionButton question={'Заблокировать колесо?'}
                                       button={{
                                           children: 'Блок.',
                                           basic: true,
                                       }}
                                       showConfirm
                                       accept={carControlHandle.bind(null, SCOOTER_ACTIONS.CLOSE_DOORS)}
                                       ytLog={{
                                           button_name: buttonNameDetails.LOCK_WHEEL,
                                           location: buttonLocationDetails.CLIENT_CARD,
                                       }}/>
                </div>

                <QuickActionButton question={'Открыть замок?'}
                                   button={{
                                       children: 'Открыть замок',
                                       basic: true,
                                   }}
                                   showConfirm
                                   className={styles.scooter_button}
                                   accept={carControlHandle.bind(null, SCOOTER_ACTIONS.SCENARIO_UNLOCK_DOORS_AND_HOOD)}
                                   ytLog={{
                                       button_name: buttonNameDetails.UNLOCK_SCOOTER,
                                       location: buttonLocationDetails.CLIENT_CARD,
                                   }}/>

                <QuickActionButton question={'Открыть крышку?'}
                                   button={{
                                       children: 'Открыть крышку',
                                       basic: true,
                                   }}
                                   showConfirm
                                   className={styles.scooter_button}
                                   accept={carControlHandle.bind(null, SCOOTER_ACTIONS.YADRIVE_UNLOCK_HOOD)}
                                   ytLog={{
                                       button_name: buttonNameDetails.UNLOCK_HOOD,
                                       location: buttonLocationDetails.CLIENT_CARD,
                                   }}/>

                <QuickActionButton question={'Подсветить самокат?'}
                                   button={{
                                       children: 'Подсветить самокат',
                                       basic: true,
                                   }}
                                   showConfirm
                                   className={styles.scooter_button}
                                   accept={carControlHandle.bind(null, SCOOTER_ACTIONS.HORN_AND_BLINK)}
                                   ytLog={{
                                       button_name: buttonNameDetails.SHOW_SCOOTER,
                                       location: buttonLocationDetails.CLIENT_CARD,
                                   }}/>
            </>
            : null
        }
    </div>;
});
