import * as React from 'react';

import { ICar } from '../../../../../types';
import { EMPTY_DATA } from '../../../../constants';
import { CarInfoHandler } from '../../../../models/car';
import SessionsHistoryItem from '../../../../models/session';
import { Link } from '../../../../ui/Link';
import LS from '../../../../utils/localStorage/localStorage';
import { ICCViewSessionMapState } from './index';
import * as styles from './index.css';

interface ICCTelematics extends ICCViewSessionMapState {
    sessions: SessionsHistoryItem | null;
    index: number;
    car: ICar | null;
}

export const CCTelematics = (props: ICCTelematics) => {
    const { car, transformToScooter = (str) => str } = props;
    const [isExpanded, setExpanded] = React.useState(false);
    const ls = new LS();
    const showAdditionalInfo = !ls.envIsScooter();

    return (
        <div className={styles.telematics_info}>
            <div className={styles.table}>
                <div>
                    <p>Уровень&nbsp;{transformToScooter('топлива')}:
                        <strong> {CarInfoHandler.getFuelLevel.call(car) ?? '?'}%</strong>
                    </p>
                    <p>{transformToScooter('Двигатель')}:
                        <strong>{CarInfoHandler.isEngineOn.call(car) ? ' вкл' : ' выкл'}</strong>
                    </p>
                    {isExpanded && (
                        <>
                            <p>Левая&nbsp;передняя:
                                <strong>
                                    {CarInfoHandler.isFrontLeftDoorOpen.call(car) ? ' открыта' : ` ${EMPTY_DATA}`}
                                </strong>
                            </p>
                            <p>Правая&nbsp;передняя:
                                <strong>
                                    {CarInfoHandler.isFrontRightDoorOpen.call(car) ? ' открыта' : ` ${EMPTY_DATA}`}
                                </strong>
                            </p>
                            <p>Левая&nbsp;задняя:
                                <strong>
                                    {CarInfoHandler.isRearLeftDoorOpen.call(car) ? ' открыта' : ` ${EMPTY_DATA}`}
                                </strong>
                            </p>
                            <p>Правая&nbsp;задняя:
                                <strong>
                                    {CarInfoHandler.isRearRightDoorOpen.call(car) ? 'открыта' : ` ${EMPTY_DATA}`}
                                </strong>
                            </p>
                        </>
                    )}
                </div>
                <div>
                    <p>АКБ:
                        <strong> {CarInfoHandler.getExtLevel.call(car) ?? '?'}</strong>
                    </p>
                    {isExpanded && (
                        <>
                            <p>Багажник:
                                <strong>{CarInfoHandler.isTrunkOpen.call(car) ? ' открыт' : ' закрыт'}</strong>
                            </p>
                            <p>Капот:
                                <strong>{CarInfoHandler.isHoodOpen.call(car) ? ' открыт' : ' закрыт'}</strong>
                            </p>
                        </>
                    )}
                </div>
            </div>

            {showAdditionalInfo
                ? <Link onClick={setExpanded.bind(null, !isExpanded)}
                        className={styles.show_more}>
                    {isExpanded ? 'Скрыть' : 'Показать всё'}
                </Link>
                : null
            }
        </div>
    );
};
