import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX, GVARS_SCOOTER_PREFIX } from '../../../../constants';
import { getRawSetting2 } from '../../../../utils/getRawSetting';
import { transformToScooterConstructor } from '../../../../utils/transformToScooter';
import { IStore } from '../../../App/store';
import { CCTelematics } from './component';

export interface ICCViewSessionMapState {
    transformToScooter?: (key: string) => string;
}

const scooterKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${GVARS_SCOOTER_PREFIX}`;

export const mapStateToProps = (store: IStore) => {
    const scooterLabels = getRawSetting2(store, scooterKey);

    return {
        transformToScooter: transformToScooterConstructor(scooterLabels),
    };
};

export default connect<{}, {}>(mapStateToProps)(CCTelematics);
