import * as React from 'react';

import UserInfo from '../../../../models/user';
import { copySessionText } from '../../../Chats/utils';
import { Copy } from '../../../Copy';
import CCSidebar from '../CCSidebar';
import * as styles from './index.css';

interface ICCViewEmptySessionProps {
    user: UserInfo | null;
}

export const CCViewEmptySession = (props: ICCViewEmptySessionProps) => {
    const { user } = props;

    return (
        <div className={styles.session}>
            <CCSidebar sessions={null}
                       user={user}
                       car={null}
                       index={0}
                       getData={() => undefined}/>
            <Copy internalTooltipId={`session_info`}
                  className={styles.copy}
                  text={copySessionText(user as UserInfo)}>
                <p className={styles.main}>
                    ПОЕЗДОК НЕ БЫЛО
                </p>
            </Copy>
        </div>
    );
};
