import React from 'react';

import { RESERVATION_FEATURES } from '../../../../constants';
import { NextOrder } from '../../../CarCard/CarInfo/NextOrder';
import CCOfferInfo from '../CCOfferInfo';
import CCRouteInfo from '../CCRouteInfo';
import CCSessionInfo from '../CCSessionInfo';
import CCTelematics from '../CCTelematics';
import { FuturesOffer } from './futuresOffer';
import styles from './index.css';

export const CCContent = ({ sessions, index, car, user, tagsObject, sessionCurrentData }) => {
    const showNextSessionRow = (car?.tags?.find(el => el.tag === RESERVATION_FEATURES)
        || sessionCurrentData.futures_offer) ?? false;

    return <>
        <CCSessionInfo sessions={sessions}
                       index={index}
                       car={car}
                       user={user}/>
        <CCOfferInfo sessions={sessions}
                     index={index}/>
        <CCRouteInfo tagsObject={tagsObject}
                     sessions={sessions}
                     index={index}/>
        <CCTelematics sessions={sessions}
                      index={index}
                      car={car}/>
        {showNextSessionRow && (
            <div className={styles.next_session}>
                {
                    car
                    && car.tags
                    && Array.isArray(car.tags)
                    && <NextOrder data={car.tags}
                                  carNumber={car.number || ''}/>
                }
                {sessionCurrentData?.futures_offer &&
                <FuturesOffer session={sessionCurrentData}/>
                }
            </div>
        )}
    </>;
};
