import React, { useEffect } from 'react';

import { useRequestHandler } from '../../../../hooks/useRequestHandler';
import { UserInfoHandler } from '../../../../models/user';
import { Request2 } from '../../../../utils/request';
import MiniMap from '../../../MiniMap';
import { CC_REQUESTS as requestConfigs, REQUESTS } from './../request';
import styles from './index.css';
import { MiniMapCatchError } from './miniMapCatchError';

interface ICCMapProps {
    showMap;
    car;
    user;
}

export const CCMap = ({ showMap, car, user }: ICCMapProps) => {
    const [isMap, setMap] = React.useState(showMap);
    const openMap = () => {
        setMap(!isMap);
    };

    const delta = 0.01;
    const half = 0.5;

    const request = new Request2({ requestConfigs });

    const requestOption = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_CAR_LIST,
            requestOptions: {
                queryParams: {
                    traits: 'ReportLocationDetails,ReportLocationCourse',
                    ne: `${+user?.realtime_data?.longitude - delta} ${+user?.realtime_data?.latitude + delta * half}`,
                    sw: `${+user?.realtime_data?.longitude + delta} ${+user?.realtime_data?.latitude - delta * half}`,
                },
                headers: { UserIdDelegation: user.id },
            },
        };
    }, [user.id, user?.realtime_data?.longitude]);

    const [, availableCars, , exec] = useRequestHandler(request, requestOption);

    useEffect(() => {
        if (user.id && user.realtime_data?.longitude) {
            exec();
        }
    }, [user.id, user.realtime_data?.longitude]);

    return <> {!isMap && (
        <div className={styles.show_map}
             onClick={openMap}>
            {isMap ? '▼ Скрыть карту' : '▶ Показать карту'}
        </div>
    )}
    {isMap && (
        <div className={styles.minimap}>
            <MiniMapCatchError>
                <MiniMap availableCars={availableCars}
                         mapId={car?.id}
                         carInfo={car}
                         userRealtimeData={UserInfoHandler.getRealtimeData.call(user)}
                         showExpandButton/>
            </MiniMapCatchError>
        </div>
    )}
    </>;
};
