import React from 'react';

import { Dict, ICar } from '../../../../../types';
import SessionsHistoryItem from '../../../../models/session';
import UserInfo from '../../../../models/user';
import CCSidebar from '../CCSidebar';
import { CCContent } from './CCContent';
import { CCMap } from './CCMap';
import styles from './index.css';

interface ICCViewSessionProps {
    sessions: SessionsHistoryItem | null;
    index: number;
    car: ICar | null;
    user: UserInfo | null;
    showMap: boolean;
    getData: () => void;
    sessionCurrentData: any;
    tagsObject: Dict<any>;
}

export const CCViewSession = (props: ICCViewSessionProps) => {
    const { sessions, index, car, user, showMap, sessionCurrentData, tagsObject } = props;

    return (
        <div className={styles.session}>
            <CCSidebar sessions={sessions}
                       index={index}
                       user={user}
                       car={car}
                       getData={props.getData}/>
            <div className={styles.content}>
                <CCContent sessions={sessions}
                           index={index}
                           car={car}
                           user={user}
                           tagsObject={tagsObject}
                           sessionCurrentData={sessionCurrentData}/>
                <CCMap showMap={showMap}
                       car={car}
                       user={user}/>
            </div>
        </div>
    );
};
