import React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import CarNumber from '../../../CarNumber';

export const FuturesOffer = (props: { session: any }) => {
    const { session } = props;
    const back = encodeURIComponent(location.hash);

    return <div>
        {!session.futures_offer_failed
            ? <>
                <div>
                    <strong>Следующая: </strong> <a href={`#/cars/${session.car && session.car.id}/info?back=${back}`}>
                        {session?.models[session?.car?.model_id]?.name ?? (session?.car?.model_id ?? EMPTY_DATA)}
                    </a></div>
                <div>{(session?.car && <CarNumber carInfo={session.car}/>) ?? EMPTY_DATA}</div>
            </>
            : <>
                <div><strong>Проблемы с заказом</strong></div>
                <div><strong>следующего авто</strong></div>
            </>
        }
        <div><strong>Оффер: </strong>{session.futures_offer?.name ?? EMPTY_DATA}</div>
        <div>
            <strong>До: </strong>
            {session.futures_offer?.deadline &&
            <FormatDate value={session.futures_offer.deadline * ONE_SECOND}
                        withSecond/>
            }
        </div>
    </div>;
};
