import * as React from 'react';

import { Collapse } from '../../../../ui/Collapse';
import { ErrorSource, logError } from '../../../Content/initErrorCounter';
import { SimpleError } from '../../../SimpleError';

export class MiniMapCatchError extends React.Component<any, any> {
    state: any = {
        error: null,
    };

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo) {
        logError(error, ErrorSource.ERROR_BOUNDARY, errorInfo);
        this.setState({
            error,
        });
    }

    render() {
        return !this.state.error ? this.props.children : <div style={{ maxHeight: '400px' }}>
            <SimpleError error={this.state.error}/>
            <Collapse title={'Что-то сломалось в карте...'} collapsed>
                <div style={{ fontSize: '.7em', overflow: 'auto' }}>{this.state.error?.stack}</div>
            </Collapse>
        </div>;
    }
}
