import { IComponentRequest } from '../../../utils/request';

export enum REQUESTS {
    GET_USER_INFO = 'GET_USER_INFO',
    GET_USER_SESSIONS = 'GET_USER_SESSIONS',
    GET_USER_PROFILE = 'GET_USER_PROFILE',
    GET_CAR_INFO = 'GET_CAR_INFO',
    CAR_ACTION_STAFF = 'CAR_ACTION_STAFF',
    FINISH_CAR_SESSION = 'FINISH_CAR_SESSION',
    GET_SESSIONS_CURRENT = 'GET_SESSIONS_CURRENT',
    GET_CAR_LIST = 'GET_CAR_LIST'
}

export const CC_REQUESTS: IComponentRequest = {

    [REQUESTS.GET_CAR_LIST]: {
        api: 'car/list',
        cgiObj: {
            ne: null,
            sw: null,
            limit: null,
            composite_filter: null,
            tags_filter: null,
            traits: null,
        },
    },
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_SESSIONS]: {
        api: 'sessions/history',
        cgiObj: {
            ts_since: null,
            user_id: null,
            numdoc: null,
        },
    },
    [REQUESTS.GET_USER_PROFILE]: {
        api: 'user/profile',
        cgiObj: {
            user_id: null,
        },
    },

    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.CAR_ACTION_STAFF]: {
        api: 'car/control',
        cgiObj: {
            car_id: null,
            command: null,
        },
    },
    [REQUESTS.FINISH_CAR_SESSION]: {
        api: 'sessions/drop',
        cgiObj: {
            evolution_mode: null,
            session_id: null,
        },
    },
    [REQUESTS.GET_SESSIONS_CURRENT]: {
        api: 'sessions/current',
        cgiObj: {
            user_id: null,
        },
    },
};
