import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../../utils/request';

export enum REQUESTS {
    GET_CHECKS = 'GET_CHECKS',
    GET_STATUS = 'GET_STATUS',
}

export const DOCUMENTS_CHECK_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CHECKS]: {
        api: 'documents_checks/get',
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_STATUS]: {
        api: 'documents_checks/get_history',
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            user_id: null,
            type: null,
        },
    },
};
