import React from 'react';

import { IPicture } from '../../../../ui/PictureBlocksViewer';
import { Request2 } from '../../../../utils/request';
import { PictureGallery } from '../../../PictureGallery';
import { CLIENTS_CARD_REQUESTS as requestConfigs, REQUESTS } from '../../request';

interface ISelfiesGalleryProps {
    showVideo: boolean;
    onPictureChange: (index: number) => void;
    currentPhotoIndex: number | null;
    getControls: () => React.ReactElement | undefined;
    selfies: Record<string, any>[];
    modifiedPhotos: IPicture[];
    userId: string;
}

interface ISelfiesGalleryState {
    photos: IPicture[];
    videos: IPicture[];
    errors: (Error | null)[];
}

export default class SelfiesGallery extends React.Component<ISelfiesGalleryProps, ISelfiesGalleryState> {
    state: ISelfiesGalleryState = {
        photos: [],
        videos: [],
        errors: [],
    };
    request = new Request2({ requestConfigs });

    componentDidMount() {
        this.setInitialMedia();
    }

    componentDidUpdate(prevProps: Readonly<ISelfiesGalleryProps>) {
        const { showVideo, currentPhotoIndex, modifiedPhotos } = this.props;
        const currentArray = this.getCurrentMedia();
        const shouldRetry = currentArray?.[currentPhotoIndex || 0]?.info?.retry;
        const isInCurrentArray = !!currentArray?.[currentPhotoIndex || 0];

        if (currentArray?.length && (!isInCurrentArray || shouldRetry)) {
            if (shouldRetry
                || (!modifiedPhotos?.[currentPhotoIndex || 0] && !isInCurrentArray)
                || (!isInCurrentArray && showVideo)) {
                this.preparePhotos(showVideo);
            } else if (!isInCurrentArray && modifiedPhotos?.[currentPhotoIndex || 0]) {
                currentArray[currentPhotoIndex || 0] = modifiedPhotos[currentPhotoIndex || 0];
                this.setState({ photos: currentArray });
            }
        }
    }

    getCurrentMedia() {
        const { showVideo } = this.props;
        const { videos, photos } = this.state;

        return showVideo ? videos : photos;
    }

    setInitialMedia() {
        const { selfies, modifiedPhotos } = this.props;
        const photos = modifiedPhotos ? [...modifiedPhotos] : [];
        photos.length = selfies.length;

        this.setState({
            photos,
            videos: new Array(selfies.length),
        });
    }

    preparePhotos(showVideo?: boolean) {
        const { selfies, userId, currentPhotoIndex = 0 } = this.props;
        const { errors: stateErrors } = this.state;
        const currentArray = this.getCurrentMedia()?.slice();

        this.request.exec(REQUESTS.GET_USER_DOC_DATA, {
            queryParams: {
                user_id: userId,
                photo_id: selfies[currentPhotoIndex || 0]?.id,
                background_video: showVideo,
            },
            blob: true,
        })
            .then(response => {
                const { currentPhotoIndex } = this.props;
                const URL = window.URL || window.webkitURL;

                const errors = [...stateErrors];
                currentArray[currentPhotoIndex || 0] = { link: URL.createObjectURL(response), info: {} };
                errors[currentPhotoIndex || 0] = null;

                if (showVideo) {
                    this.setState({ videos: currentArray });
                } else {
                    this.setState({ photos: currentArray, errors });
                }
            }).catch((error) => {
                currentArray[currentPhotoIndex || 0] = { link: 'error', info: {} };

                if (!showVideo) {
                    const errors = stateErrors ? [...stateErrors] : [];
                    errors[currentPhotoIndex || 0] = error;
                    this.setState({ errors, photos: currentArray });
                } else {
                    this.setState({ videos: currentArray });
                }
            });
    }

    render() {
        const {
            showVideo,
            currentPhotoIndex,
            onPictureChange,
            getControls,
        } = this.props;

        return <PictureGallery video={showVideo}
                               controls={getControls()}
                               initialIndex={currentPhotoIndex || 0}
                               onChange={onPictureChange.bind(this)}
                               pictures={this.getCurrentMedia()}
                               errors={this.state.errors}
                               onClose={onPictureChange.bind(this, null)}/>;
    }
}
