export const DOCUMENTS_KEYS = {
    passport: {
        key: 'passport',
        display_name: 'Паспорт',

        selfie: { key: 'selfie', display_text: 'Селфи с паспортом' },
        biographical: { key: 'biographical', display_text: 'Фронт' },
        registration: { key: 'registration', display_text: 'Прописка' },
    },
    driving_license: {
        key: 'driving_license',
        display_name: 'Водительское удостоверение',
        yang_key: 'license',

        front: { key: 'front', display_text: 'Права фронт' },
        back: { key: 'back', display_text: 'Права оборот' },
        selfie: { key: 'selfie', display_text: 'Селфи с правами' },
    },
    selfies: {
        key: 'selfies',
        display_name: 'Селфи',
    },
};
export const IS_FIRST_RIDING_TITLE = 'Будет первая поездка';

export const CURRENT_PHOTO_TYPE_SEPARATOR = '/';
export const CGI_SEPARATOR = '?';

export const VIDEO_SHOW_MODE = 'x';
export const PHOTO_SHOW_MODE = 'photo';

export const APPROVING_PHOTO_REG_EXP = /photos\/(.*)\/content\//;

export const DOC_STATUS_MAP: Record<string, Record<string, string>> = {
    o: {
        key: 'o',
        text: 'ОК',
        status: 'positive',
    },
    n: {
        key: 'n',
        text: 'НЕ ОК',
        status: 'negative',
    },
    i: {
        key: 'i',
        text: 'ОТКАЗ',
        status: 'negative',
    },
    u: {
        key: 'u',
        text: 'unrec'.toLocaleUpperCase(),
        status: 'warning',
    },
    f: {
        key: 'f',
        text: 'foreign'.toLocaleUpperCase(),
        status: 'warning',
    },
    d: {
        key: 'd',
        text: 'Discarded'.toLocaleUpperCase(),
        status: 'negative',
    },
    v: {
        key: 'v',
        text: 'VideoScreencap'.toLocaleUpperCase(),
        status: 'warning',
    },
    a: {
        key: 'a',
        text: 'AnotherPerson'.toLocaleUpperCase(),
        status: 'negative',
    },
    e: {
        key: 'e',
        text: 'VideoError'.toLocaleUpperCase(),
        status: 'warning',
    },
    '-': {
        key: '-',
        text: 'NotYetProcessed'.toLocaleUpperCase(),
        status: 'warning',
    },
};

export const FRAUD_STATUSES = {
    MAYBE_FRAUD: {
        key: 'maybe_fraud',
        display_text: 'Возможно мошенник',
    },
    NOT_FRAUD: {
        key: 'not_fraud',
        display_text: 'Не мошенник',
    },
    DEFINITELY_FRAUD: {
        key: 'definitely_fraud',
        display_text: 'Точно мошенник',
    },
};

export const TYPE_ITEMS = [
    {
        text: DOCUMENTS_KEYS.passport.selfie.display_text,
        value: `${DOCUMENTS_KEYS.passport.key}/${DOCUMENTS_KEYS.passport.selfie.key}`,
    },
    {
        text: DOCUMENTS_KEYS.passport.biographical.display_text,
        value: `${DOCUMENTS_KEYS.passport.key}/${DOCUMENTS_KEYS.passport.biographical.key}`,
    },
    {
        text: DOCUMENTS_KEYS.passport.registration.display_text,
        value: `${DOCUMENTS_KEYS.passport.key}/${DOCUMENTS_KEYS.passport.registration.key}`,
    },
    {
        text: DOCUMENTS_KEYS.driving_license.front.display_text,
        value: `${DOCUMENTS_KEYS.driving_license.key}/${DOCUMENTS_KEYS.driving_license.front.key}`,
    },
    {
        text: DOCUMENTS_KEYS.driving_license.back.display_text,
        value: `${DOCUMENTS_KEYS.driving_license.key}/${DOCUMENTS_KEYS.driving_license.back.key}`,
    },
    {
        text: DOCUMENTS_KEYS.driving_license.selfie.display_text,
        value: `${DOCUMENTS_KEYS.driving_license.key}/${DOCUMENTS_KEYS.driving_license.selfie.key}`,
    },
];
export const MEDIA_ITEMS = [
    { text: 'Фото', value: PHOTO_SHOW_MODE },
    { text: 'Видео', value: VIDEO_SHOW_MODE },
];
