import React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { Dict } from '../../../../../types';
import { useWindowResize } from '../../../../hooks/useWindowResize';
import { FinesRoutes } from '../../../../utils/navigation';
import { CARS_MARGIN, CLIENTS_MARGIN } from '../constants';
import * as handleStyle from '../index.css';
import { FullFinesInfoItem } from './FullFinesInfoItem';

const ITEM_SIZE = 275;
const FULL_FINES_MARGIN = 25;

interface IFullFinesInfoProps {
    route: string;
    data: Dict<any>;
    showPhoto: (url: string) => void;
    showEmailButton?: boolean;
    openDecree: () => void;
    openResendConfirm: (id: string) => void;
    showModal: (type: string, id: string) => void;
    openResendConfirmWithDoc: (id: string) => void;
    onProtocolButtonClick: (item) => void;
    onAttorneyButtonClick: (item?: any) => void;
    attorneyForQueueModalId: string | null;
}

export const FullFinesInfo = React.memo((props: IFullFinesInfoProps) => {
    const isCarRoute = props.route === FinesRoutes.cars;
    const window = useWindowResize();

    return <div className={handleStyle.table}>
        <VirtualList itemCount={props.data?.length}
                     itemSize={ITEM_SIZE}
                     height={window.height - (isCarRoute ? CARS_MARGIN : CLIENTS_MARGIN) + FULL_FINES_MARGIN}
                     renderItem={({ index, style }) => {
                         const item = props.data[index];

                         return <FullFinesInfoItem item={item}
                                                   index={index}
                                                   style={style}
                                                   key={index}
                                                   onProtocolButtonClick={props.onProtocolButtonClick}
                                                   openResendConfirmWithDoc={props.openResendConfirmWithDoc}
                                                   onAttorneyButtonClick={props.onAttorneyButtonClick}
                                                   attorneyForQueueModalId={props.attorneyForQueueModalId}
                                                   showPhoto={props.showPhoto}
                                                   showModal={props.showModal}
                                                   showEmailButton={props.showEmailButton}
                                                   openResendConfirm={props.openResendConfirm}/>;
                     }}/>
    </div>;
});
