import * as React from 'react';

import { Dict } from '../../../../../types';
import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Request2 } from '../../../../utils/request';
import { FormConstructor } from '../../../FormConstructor';
import Spin from '../../../Spin';
import { CORE_DRIVE_LENS_REQUESTS, REQUESTS } from '../request';

interface IReassignFineModalProps {
    onClose: () => void;
    fineId: string;
}

interface IReassignFineModalState {
    error: Error | null;
    isLoading: boolean;
    schema: any;
    initialData: Dict<string | Dict<string>>;
    data: any;
    isWorking: boolean;
}

export class ReassignFineModal extends React.Component<IReassignFineModalProps, IReassignFineModalState> {
    state: IReassignFineModalState = {
        error: null,
        isLoading: false,
        schema: {},
        initialData: {
            fine_id: this.props.fineId,
        },
        data: {},
        isWorking: false,
    };

    request = new Request2({ requestConfigs: CORE_DRIVE_LENS_REQUESTS });

    getData() {
        this.setState({
            isLoading: true,
        }, async () => {
            try {
                const schema = await this.request.exec(REQUESTS.REASSIGN_FINE, {
                    queryParams: {
                        scheme: true,
                    },
                });

                this.setState({
                    schema: schema?.request_data?.structure,
                    isLoading: false,
                });
            } catch (error) {
                this.setState({
                    error,
                    isLoading: false,
                });
            }

        });
    }

    send() {
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.REASSIGN_FINE, {
                body: this.state.data,
            })
                .then(() => {
                    this.setState({
                        isWorking: false,
                    });
                    this.props.onClose();
                })
                .catch((error) => {
                    this.setState({
                        error,
                        isWorking: false,
                    });
                });
        });
    }

    componentDidMount() {
        this.getData();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    onChange(data) {
        this.setState({
            data,
        });
    }

    render() {
        const { error, isLoading, schema, initialData } = this.state;
        const { onClose } = this.props;

        return (
            <Window title={'Переназначить штраф'}
                    onClose={onClose}
                    error={error}>
                {isLoading
                    ? <Spin/>
                    : (
                        <>
                            <FormConstructor initialData={initialData}
                                             schema={schema}
                                             onChange={this.onChange.bind(this)}/>
                            <div className={coreStyle.button_container}>
                                <Button onClick={onClose.bind(this)}
                                        basic>Отмена</Button>
                                <Button onClick={this.send.bind(this)}>Отправить</Button>
                            </div>
                        </>
                    )
                }
            </Window>
        );
    }
}
