import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { Dict } from '../../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import { useWindowResize } from '../../../../hooks/useWindowResize';
import { UserInfoHandler } from '../../../../models/user';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { FinesRoutes } from '../../../../utils/navigation';
import { rubs } from '../../../../utils/rubs';
import CarNumber from '../../../CarNumber';
import { CARS_MARGIN, CLIENTS_MARGIN, FINES_TOOLTIP_ID, RESOLUTION_PREFIX } from '../constants';
import * as handleStyle from '../index.css';

const ITEM_SIZE = 40;

interface IShortFinesInfoProps {
    data: Dict<any>;
    onShortItemClick: (item) => void;
    route: string;
}

export const ShortFinesInfo = React.memo((props: IShortFinesInfoProps) => {
    const isCarRoute = props.route === FinesRoutes.cars;
    const window = useWindowResize();

    function onNumberClick(e) {
        e.stopPropagation();
    }

    const back = encodeURIComponent(location.hash);

    return <div className={`${handleStyle.table} ${handleStyle.short_table}`}>
        <div className={handleStyle.table_header}>
            <span className={handleStyle.index}/>
            <span className={handleStyle.date}>Дата</span>
            <span className={handleStyle.sum_to_pay}>Сумма</span>
            {isCarRoute
                ? <span className={handleStyle.username}>Пользователь</span>
                : <>
                    <span className={handleStyle.model}>Автомобиль</span>
                    <span className={handleStyle.number}/>
                </>
            }
            <span className={handleStyle.rul_number}>Постановление №</span>
        </div>

        <VirtualList itemCount={props.data?.length}
                     itemSize={ITEM_SIZE}
                     height={window.height - (isCarRoute ? CARS_MARGIN : CLIENTS_MARGIN)}
                     renderItem={({ index, style }) => {
                         const el = props.data[index];

                         return <div key={index}
                                     style={style}
                                     className={handleStyle.short_item}
                                     onClick={props.onShortItemClick.bind(null, el)}>
                             <span className={handleStyle.index}>{index + 1}.</span>
                             <span className={handleStyle.date}>
                                 <FormatDate value={el.violation_time * ONE_SECOND}/>
                             </span>
                             <span className={handleStyle.sum_to_pay}>
                                 {el.sum_to_pay ? rubs(el.sum_to_pay) : EMPTY_DATA}
                             </span>
                             {isCarRoute
                                 ? <>
                                     <span className={handleStyle.username}>
                                         <Link href={`#/clients/${UserInfoHandler.getId.call(el.user)}/info`}>
                                             {UserInfoHandler.getPrintName.call(el.user) ?? EMPTY_DATA}
                                         </Link>
                                     </span>
                                 </>
                                 : <>
                                     <span className={handleStyle.model}>
                                         {el.car?.model?.name
                                             ? <Link href={'#/cars/' + el.car.id + `/info?back=${back}`}>
                                                 {el.car.model.name}
                                             </Link>
                                             : EMPTY_DATA
                                         }
                                     </span>
                                     <span className={handleStyle.number}>
                                         <div className={handleStyle.short_car_number}>
                                             <span onClick={onNumberClick.bind(null)}>
                                                 {el.car?.number
                                                     ? <CarNumber carInfo={el.car}
                                                                  externalTooltipId={FINES_TOOLTIP_ID}/>
                                                     : EMPTY_DATA}
                                             </span>
                                         </div>
                                     </span>
                                 </>
                             }
                             <span className={handleStyle.rul_number}>
                                 {el.ruling_number
                                     ? <Link href={`${RESOLUTION_PREFIX}${el.ruling_number}`}
                                             target={'__blank'}>
                                         {el.ruling_number}
                                     </Link>
                                     : EMPTY_DATA
                                 }
                             </span>
                         </div>;
                     }}/>
    </div>;
});
