import { Dict } from '../../../../types';
import { combineRequests, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';
import { FINE_REQUEST, FINE_REQUEST_ENUM } from '../../Fines/request';

export const REQUESTS: Dict<string> = combineRequests({
    RESEND_FINE_EMAIL: 'RESEND_FINE_EMAIL',
    DECREE_INFO: 'DECREE_INFO',
    REASSIGN_FINE: 'REASSIGN_FINE',
    GET_CAR_INFO: 'GET_CAR_INFO',
},
FINE_REQUEST_ENUM);

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = combineRequests({
    [REQUESTS.RESEND_FINE_EMAIL]: {
        method: REQUEST_METHOD.POST,
        api: 'fines/resend_email',
        cgiObj: {
            fine_id: null,
        },
    },
    [REQUESTS.DECREE_INFO]: {
        api: 'fines/decree_info',
        cgiObj: {
            fine_id: null,
        },
    },
    [REQUESTS.REASSIGN_FINE]: {
        method: REQUEST_METHOD.POST,
        api: 'fines/reassign',
        cgiObj: {
            fine_id: null,
            scheme: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
}, FINE_REQUEST);
