import moment from 'moment';
import * as React from 'react';

import { ISearchControls, WithSearchControls } from '../../../../decorators/SearchControls';
import { EMPTY_DATA, ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import { Link } from '../../../ui/Link';
import { NoInformation } from '../../../ui/NoInformation';
import * as tblStyle from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import CarNumber from '../../CarNumber';
import { CheckFuelStatus } from '../../CheckFuelStatus/component';
import FuelOrder from '../../FuelOrder';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import * as styles from './index.css';
import { FUEL_USAGES_REQUESTS, REQUESTS } from './request';

interface IFuelUsagesProps extends ISearchControls {
    userId?: string;
    carId?: string;
}

interface IFuelUsagesState {
    dataNew: any;
    errorNew: Error | null;
    isLoadingNew: boolean;
    currentPage: number;
    cars: any;
}

const USER_FUELING_TAG = 'user_fueling_tag';
const SINCE_SUBTRACT = 30;

@WithSearchControls({ until: moment(), since: moment().subtract(SINCE_SUBTRACT, 'd') })
export class FuelUsages extends React.Component<IFuelUsagesProps, IFuelUsagesState> {
    state: IFuelUsagesState = {
        dataNew: [],
        errorNew: null,
        isLoadingNew: false,
        currentPage: 1,
        cars: [],
    };

    request = new Request2({ requestConfigs: FUEL_USAGES_REQUESTS });

    getNewData() {
        const { userId, carId, since, until } = this.props;
        if (userId) {
            this.request.exec(REQUESTS.GET_USER_TAG_HISTORY, {
                queryParams: {
                    object_id: userId,
                    tag_name: USER_FUELING_TAG,
                    since: since && +since && Math.round(+since / ONE_SECOND) || null,
                    until: until && +until && Math.round(+until / ONE_SECOND) || null,
                },
            })
                .then(response => {
                    let cars = new Set();

                    const tagsObj = response.records
                        && response.records.reduce((_p: any, _c: any) => {
                            if (_c.tag_name === USER_FUELING_TAG) {
                                if (!_p.hasOwnProperty(_c.tag_id)) {
                                    _p[_c.tag_id] = [_c];
                                    _c.tag_details && _c.tag_details.object_id && cars.add(_c.tag_details.object_id);
                                } else {
                                    _p[_c.tag_id].push(_c);
                                }
                            }

                            return _p;
                        }, {});

                    this.request.exec(REQUESTS.GET_CARS, {
                        queryParams: {
                            car_id: [...cars].join(','),
                        },
                    })
                        .then(_response => {
                            cars = _response.cars && _response.cars.reduce((_p: any, _c: any) => {
                                if (!_p.hasOwnProperty(_c.id)) {
                                    _p[_c.id] = _c;
                                }

                                return _p;
                            }, {});

                            this.setState({
                                dataNew: tagsObj && Object.entries(tagsObj) || [],
                                cars,
                                isLoadingNew: false,
                            });
                        })
                        .catch((errorNew) => {
                            this.setState({
                                errorNew,
                            });
                        });
                })
                .catch((errorNew) => {
                    this.setState({
                        errorNew,
                    });
                });
        }

        if (carId) {
            this.request.exec(REQUESTS.GET_CAR_TAGS_HISTORY, {
                queryParams: {
                    car_id: carId,
                    tags: USER_FUELING_TAG,
                    since: since && +since && Math.round(+since / ONE_SECOND) || null,
                    until: until && +until && Math.round(+until / ONE_SECOND) || null,
                },
            })
                .then(response => {
                    const tagsObj = response.records
                        && response.records
                            .reduce((_p: any, _c: any) => {
                                if (_c.tag_name === USER_FUELING_TAG) {
                                    if (!_p.hasOwnProperty(_c.tag_id)) {
                                        _p[_c.tag_id] = [_c];
                                    } else {
                                        _p[_c.tag_id].push(_c);
                                    }
                                }

                                return _p;
                            }, {});

                    this.setState({
                        dataNew: tagsObj && Object.entries(tagsObj) || [],
                        isLoadingNew: false,
                    });
                })
                .catch((errorNew) => {
                    this.setState({
                        errorNew,
                    });
                });
        }
    }

    componentDidUpdate(prevProps: Readonly<IFuelUsagesProps>) {
        if (this.props.since !== prevProps.since || this.props.until !== prevProps.until) {
            this.getNewData();
        }
    }

    componentDidMount() {
        this.getNewData();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        const { userId, carId } = this.props;
        const { errorNew, isLoadingNew, dataNew, cars } = this.state;
        const back = encodeURIComponent(location.hash);

        return (
            <>
                <div className={styles.button_wrapper}>
                    <FuelOrder/>

                    <CheckFuelStatus userId={userId}/>
                </div>

                {errorNew ? <SimpleError error={errorNew}/> : isLoadingNew ? <Spin/> :
                    <div className={styles.historyNew}>
                        <h4>История (новая)</h4>
                        {dataNew && dataNew.length ?
                            <table className={`${tblStyle.table} ${tblStyle.clearAllBackground}`}>
                                <tbody>
                                    {dataNew.map((_item: any[], index: number) => {
                                        const firstItem = _item[1][_item[1].length - 1];
                                        const endItem = _item[1][0];
                                        const printName = firstItem.user_data_full
                                        && (`${firstItem.user_data_full.last_name} ${firstItem.user_data_full.first_name}`);
                                        const userCarId: any = endItem.tag_details && endItem.tag_details.object_id || '';

                                        return (
                                            [<tr key={index}>
                                                <td>{index + 1}</td>
                                                <td>
                                                    <FormatDate value={firstItem.timestamp * ONE_SECOND}
                                                                withSecond/>
                                                </td>
                                                <td>
                                                    <FormatDate value={endItem.timestamp * ONE_SECOND}
                                                                withSecond/>
                                                </td>
                                                {userId &&
                                            <>
                                                <td>
                                                    {cars && cars[userCarId] && cars[userCarId].number &&
                                                    <CarNumber carInfo={cars[userCarId]}/> || EMPTY_DATA}
                                                </td>
                                                <td>
                                                    <Link href={`#/cars/${userCarId}/info?back=${back}`}>
                                                        авто
                                                    </Link>
                                                </td>
                                            </>
                                                }
                                                {carId &&
                                            <>
                                                <td>
                                                    <Link href={`${location.origin}${location.pathname}#/clients/${firstItem.user_id}/fueling`}>
                                                        {printName}
                                                    </Link>
                                                </td>
                                                <td/>
                                            </>
                                                }
                                            </tr>,
                                            _item[1].map((_sub_item: any, sub_index: number) => {
                                                return (
                                                    <tr key={`${index}_${sub_index}`}
                                                        className={styles.subTr}>
                                                        <td>{index + 1}.{sub_index + 1}</td>
                                                        <td>
                                                            <FormatDate value={_sub_item.timestamp * ONE_SECOND}
                                                                        withSecond/>
                                                        </td>
                                                        <td>{_sub_item.action}</td>
                                                        <td>{_sub_item.tag_details
                                                            && _sub_item.tag_details.current_state}
                                                        </td>
                                                        <td>{_sub_item.tag_details
                                                            && _sub_item.tag_details.comment}
                                                        </td>
                                                    </tr>
                                                );
                                            }),
                                            ]);
                                    })}
                                </tbody>
                            </table>
                            : <NoInformation/>
                        }
                    </div>
                }
            </>
        );
    }
}
