import React from 'react';
import { renderToString } from 'react-dom/server';
import ReactTooltip from 'react-tooltip';

import { Dict } from '../../../../types';
import { EMPTY_DATA } from '../../../constants';
import { IOfferProto, ISessionCurrentOffer } from '../../../models/session';
import { SessionOffer } from '../../SessionCard/SessionOffer';
import style from './index.css';

const sessionTooltipId = 'session-tooltip';

interface IOfferInfoTooltip {
    offer_proto?: IOfferProto;
    current_offer: ISessionCurrentOffer;
    index: string;
    total: string;
    className?: string;
    showBaseName?: boolean;
    BlockRules: Dict<any> | undefined;
    externalTooltipId?: string;
}

export const OfferInfoTooltip = (props: IOfferInfoTooltip) => {
    const { current_offer, offer_proto, index, total, className, showBaseName, BlockRules, externalTooltipId } = props;
    const sessionOffer = renderToString(
        <SessionOffer BlockRules={BlockRules}
                      current_offer={current_offer}
                      key={index}
                      offer_proto={offer_proto}
                      total={total}
                      className={className}/>,
    );
    const offer = current_offer?.name !== current_offer?.group_name
        ? (`${current_offer?.name} ${current_offer?.group_name ? `(${current_offer?.group_name})` : ''}`)
        : current_offer?.name || current_offer?.short_name || EMPTY_DATA;

    return current_offer
        ? <span className={style.wrapper}>
            <span data-tip={externalTooltipId ? sessionOffer : true}
                  data-place={'left'}
                  data-for={externalTooltipId ? sessionTooltipId : 'offer-' + index}
                  className={style.base_name}>
                {showBaseName
                    ? current_offer && current_offer.type && current_offer.type.split('_')[0]
                    : offer}
            </span>
            {!externalTooltipId && (
                <ReactTooltip id={'offer-' + index}
                              className={style.custom_tooltip}
                              aria-haspopup='true'
                              place={'left'}
                              type="info"
                              effect="solid">
                    <SessionOffer BlockRules={BlockRules}
                                  current_offer={current_offer}
                                  key={index}
                                  offer_proto={offer_proto}
                                  total={total}
                                  className={className}/>
                </ReactTooltip>)}
        </span>
        : <span>{EMPTY_DATA}</span>;
};
