/*eslint-disable*/
import * as React from 'react';
import { IUserRequest } from './component';
import { initMap } from '../../MainMap/utils';
import { FormatDateInString } from '../../../ui/FormatDate';
import { DEFAULT_COORDINATES, EMPTY_DATA, ONE_SECOND } from '../../../constants';

import * as styles from './index.css';

declare let ymaps: any;

interface IUserActionMapProps {
    requests: IUserRequest[],
}

export class UserActionMap extends React.Component<IUserActionMapProps> {
    map;
    objectManager;

    static colorizePreset(request: IUserRequest) {
        let code = request.code && request.code.toString()[0];
        switch (code) {
            case '2':
                return 'islands#darkGreenCircleDotIcon';
            case '4':
                return 'islands#redCircleDotIcon';
            default:
                return 'islands#orangeCircleDotIcon';
        }
    }

    static makeRequest(request: IUserRequest, index) {
        let coordinates = request.latitude && request.longitude
            && [request.longitude, request.latitude] || [DEFAULT_COORDINATES.LON, DEFAULT_COORDINATES.LAT];

        let caption = `${request.timestamp && FormatDateInString({
            value: request.timestamp * ONE_SECOND,
            withSecond: true,
        })} 
        ${request.path}`;

        let content = (
            `<div>№${index + 1}</div>` +
            `<div>Host: <strong>${request.host || EMPTY_DATA}</strong></div>` +
            `<div>Path: <strong>${request.name || request.path || EMPTY_DATA}</strong></div>` +
            `<div>Code: <strong>${request.code || EMPTY_DATA}</strong></div>`
        );

        return {
            'type': 'Feature',
            'id': index,
            'geometry': {'type': 'Point', coordinates},
            'options': {
                preset: UserActionMap.colorizePreset(request)
            },
            'properties': {
                hintContent: caption,
                balloonContent: content,
                clusterCaption: caption,
                iconContent: index + 1,
            }
        };
    };

    addObjects(requests) {
        let FeatureCollection = {
            'type': 'FeatureCollection',
            'features': requests && requests.map((request, index) => {
                return UserActionMap.makeRequest(request, index);
            }) || []
        };

        this.objectManager?.add(FeatureCollection);
    }

    drawMap() {
        let {requests} = this.props;
        let map = this.map;

        const zoomControl = new ymaps.control.ZoomControl({
            options: {
                size: 'small'
            }
        });
        map.controls.add(zoomControl);

        const typeSelector = new ymaps.control.TypeSelector([]);
        typeSelector.addMapType('yandex#map');
        typeSelector.addMapType('yandex#hybrid');
        typeSelector.addMapType('yandex#satellite');
        map.controls.add(typeSelector);

        map.options.set('minZoom', 1);
        map.options.set('autoFitToViewport', 'always');
        map.options.set('suppressMapOpenBlock', true);
        map.options.set('copyrightLogoVisible', false);
        map.options.set('copyrightProvidersVisible', false);
        map.options.set('copyrightUaVisible', false);

        const showAll = new ymaps.control.Button({
            data: {content: 'Вместить на карту'},
            options: {
                maxWidth: [150, 178]
            }
        });
        showAll.events.add('select', () => {
            requests.length && this.map.setBounds(this.map.geoObjects.getBounds());
            showAll.deselect();
        });
        this.map.controls.add(showAll, {float: 'left'});

        this.addObjects(requests);
    }

    componentDidMount() {
        initMap('userActionMap', (map) => {
            this.map = map;
            this.objectManager = new ymaps.ObjectManager({
                clusterIconLayout: 'default#pieChart',
                clusterize: true,
                gridSize: 128,
            });
            this.map.geoObjects.add(this.objectManager);
            this.drawMap();
        });
    }

    componentDidUpdate(prevProps: Readonly<IUserActionMapProps>) {
        if (prevProps.requests !== this.props.requests) {
            let {requests} = this.props;

            this.objectManager?.removeAll?.();
            this.addObjects(requests);
        }
    }

    componentWillUnmount() {
        this.map && this.map.destroy();
    }

    render() {
        return (
            <div id={'userActionMap'} className={styles.map}/>
        );
    }
}
