/*eslint-disable*/
import * as React from 'react';
import { IUserRequest } from './component';
import { SimpleError } from '../../SimpleError';
import FormatDate from '../../../ui/FormatDate';
import { EMPTY_DATA, ONE_SECOND } from '../../../constants';
import ReactTooltip from 'react-tooltip';
import { parseUA } from '../../../utils/utils';
import { Link } from '../../../ui/Link';
import Spin from '../../Spin';
import { NoInformation } from '../../../ui/NoInformation';

import * as styles from './index.css';
import VirtualList from 'react-tiny-virtual-list';
import { useWindowResize } from '../../../hooks/useWindowResize';
import YQLQuery from './YQLQuery';
import { JsonModal } from '../../../ui/FullModal/JsonModal';

interface IUserActionTableProps {
    requests: IUserRequest[],
    isLoading: boolean,
    lastItemTs: number,
    getMore: () => void,
    error: Error | null,
    withMap?: boolean,
}

export const UserActionTable = ((props: IUserActionTableProps) => {
    let {requests, isLoading, lastItemTs, getMore, error, withMap} = props;
    let [obj, setObj] = React.useState({});
    let [isJsonModalShowing, setJsonModal] = React.useState(false);
    let [yqlQuery, showYQL] = React.useState(null);
    let windowSize = useWindowResize();

    let rowCn = withMap ? `${styles.row} ${styles.rowWithMap}` : styles.row;

    const showJsonModal = (obj) => {
        setObj(obj);
        setJsonModal(true);
    };

    const closeJsonModal = () => setJsonModal(false);

    return (
        <>
            {isJsonModalShowing &&
            <JsonModal
                onClose={closeJsonModal}
                title={'JSON действия'}
                obj={obj}
            />
            }
            {
                yqlQuery && <YQLQuery request={yqlQuery}
                                      onClose={showYQL.bind(null, null)}/>
            }
            {error ? <SimpleError error={error}/> : (isLoading && !lastItemTs) ? <Spin/> :
                !requests.length ? <NoInformation/> :
                    <div>
                        <div className={`${styles.tableHeader} ${rowCn}`}>
                            <span>#</span>
                            <span>Дата</span>
                            {!withMap &&
                            <>
                                <span>Версия</span>
                                <span>Хост</span>
                            </>
                            }
                            <span>Адрес</span>
                            {!withMap && <span/>}
                        </div>
                        <VirtualList
                            width={'100%'}
                            height={windowSize.height - 360}
                            itemCount={requests.length + 1}
                            itemSize={80}
                            renderItem={({index, style}) => {
                                let request;

                                if (index < requests.length) {
                                    request = requests[index];
                                }

                                return (
                                    <React.Fragment key={index}>
                                        {request ?
                                            <RequestRow
                                                request={request}
                                                style={style}
                                                index={index}
                                                withMap={withMap}
                                                showJsonModal={showJsonModal}
                                                showYQL={showYQL}
                                                className={rowCn}
                                            /> :
                                            lastItemTs ?
                                                <div
                                                    style={style}
                                                    className={`${styles.row} ${styles.toggleMore}`}
                                                >
                                                <span>
                                                    {isLoading ? <Spin size={'s'}/> :
                                                        <Link onClick={getMore}>Ещё</Link>
                                                    }
                                                </span>
                                                </div> :
                                                undefined
                                        }
                                    </React.Fragment>
                                );

                            }}
                        />
                    </div>
            }
        </>
    );
});

const RequestRow = (props: { request: IUserRequest, style: any, index: number, withMap?: boolean, showJsonModal: (obj: any) => void, className: string, showYQL: (obj) => void }) => {
    let {request, style, index, withMap, showJsonModal, className, showYQL} = props;
    let request_path = request.name ? request.name : request.path;
    let request_car_number = <strong>
        {request.car_number ? request.car_number : undefined}
    </strong>;

    return (
        <div
            style={style}
            className={className}
        >
            <span>{index + 1}</span>
            <span>
               <FormatDate
                   value={request.timestamp && request.timestamp * ONE_SECOND}
                   withSecond
               /> <Link onClick={showYQL.bind(null, request)}>YQL</Link>
           </span>

            {!withMap &&
            <>
               <span>
                   <ReactTooltip
                       id={'tag-index-' + index}
                       place='bottom'
                       type='info'
                       aria-haspopup='true'
                   >
                       <div>user_agent: {request.user_agent}</div>
                       <div>device_id: {request.device_id}</div>
                   </ReactTooltip>
                   <span
                       data-tip={true}
                       data-for={'tag-index-' + index}
                   >
                       {(request.user_agent && parseUA(request.user_agent).version)
                       || EMPTY_DATA}
                   </span>
               </span>
                <span title={request.code ? request.code.toString() : undefined}>
                   <span
                       className={`${styles.code} ${request.code ? styles[`code-${Math.trunc(request.code / 100)}xx`] : ''}`}>
                       {(request.host && request.host.split('.')[0]) || EMPTY_DATA}
                   </span>
               </span>
            </>
            }
            <span
                className={withMap ? `${styles.code} ${request.code ? styles[`code-${request.code.toString()[0]}xx`] : ''}` : undefined}
                title={request.code && withMap ? request.code.toString() : undefined}
            >
               <div>
                   {withMap ?
                       <Link onClick={showJsonModal.bind(null, request)}>
                           {request_path} {request_car_number}
                       </Link> :
                       <span>
                           {request_path} {request_car_number}
                       </span>
                   }
               </div>
                {request.ui_message &&
                <div
                    className={styles.response}
                    title={request.ui_message}
                >
                    {request.ui_message}
                </div>
                }
                {request.landing_titles && request.landing_titles.map((title, index) =>
                    <div
                        className={styles.response}
                        key={index}
                    >
                        - {title}
                    </div>)
                }
           </span>
            {!withMap &&
            <span>
                   <Link onClick={showJsonModal.bind(null, request)}>info</Link>
               </span>
            }
        </div>
    );
};
