import { IUserRequest } from './component';

export const friendlyData = (requests: IUserRequest[]): IUserRequest[] => {
    let car_number: string | undefined;

    return requests.map(request => {
        let name = '';
        let tag_name = '';
        let response: any = '';
        try {
            response = request.response && JSON.parse(request.response);
        } catch (error) {
            response = '';
        }

        let ui_message = response.error_details &&
            response.error_details.ui_message &&
            response.error_details.ui_message;

        const landing_titles = response.landings && response.landings.map((landing: any) => landing.title);

        const queryParams = new URLSearchParams(request.query);
        car_number = queryParams.get('car_number') || undefined;

        try {
            tag_name = request.post && JSON.parse(request.post).tag_name || '';
        } catch (error) {
            tag_name = '';
        }

        switch (request.path + '/' + tag_name) {
        case '/api/yandex/car/control/start-heating':
            name = 'Прогрев';
            break;
        case '/api/yandex/car/control/blinker-flush':
            name = 'Помигать';
            break;
        case '/api/yandex/tag/evolve/old_state_acceptance':
            name = 'Начало приёмки';
            break;
        case '/api/yandex/tag/evolve/old_state_riding':
            name = 'Перевод в режим поездки';
            break;
        case '/api/yandex/tag/evolve/old_state_parking':
            name = 'Парковка';
            break;
        case '/api/yandex/tag/evolve/old_state_reservation':
            name = 'Завершение аренды';
            break;
        case '/api/yandex/offers/book/':
            name = 'Бронирование';
            break;
        case '/api/yandex/offers/create/':
            name = 'Оффер';
            break;
        case '/api/yandex/landing/info/':
            name = 'Лендинг';
            break;
        case '/api/yandex/photo/upload/':
            name = 'Отправка фото';
            break;
        }

        if (request.path === '/user_app/promo/accept') {
            name = 'Активация промокода';
            const code: any = request.query && new URLSearchParams(request.query) || {};
            ui_message += ` code: ${code && code.get && code.get('code')}`;
        }

        return {
            ...request,
            name,
            car_number,
            ui_message,
            landing_titles,
        };
    });
};
