import moment from 'moment';
import React from 'react';

import { ONE_SECOND } from '../../../constants';
import { Window } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import { REQUESTS, USER_ACTIONS_VIEW_REQUESTS } from './request';

interface IYQLQueryProps {
    request: any;
    onClose: Function;
}

interface IYQLQueryState {
    isLoading: boolean;
    error: null | Error;
    response: any;
}

export default class YQLQuery extends React.Component<IYQLQueryProps, IYQLQueryState> {
    request = new Request2({ requestConfigs: USER_ACTIONS_VIEW_REQUESTS });
    state: IYQLQueryState = {
        isLoading: true,
        error: null,
        response: null,
    };

    getToken() {
        return this.request.exec(REQUESTS.GET_TOKEN).then(response => {
            return response;
        }).catch(error => {
            this.setState({
                isLoading: false,
                error,
            });
        });
    }

    async getData() {
        let from = '';
        const timestamp = this.props.request?.timestamp * ONE_SECOND;
        if (timestamp - new Date(new Date().toLocaleDateString()).getTime() >= 0) {
            from = `FROM RANGE('home/logfeller/logs/carsharing-backend-events-log/stream/5min')`;

        } else {
            const date = moment(timestamp).format('YYYY-MM-DD');
            from = `FROM RANGE('home/logfeller/logs/carsharing-backend-events-log/1d','${date}','${date}')`;
        }

        const token = await this.getToken();
        this.request.exec(REQUESTS.CREAT_QYERY, {
            body: {
                'content': `PRAGMA yt.InferSchema;\n` +
                    `USE hahn;\n\n` +
                    `SELECT * \n` +
                    `${from} \n` +
                    `WHERE reqid = "${this.props.request.reqid}" \n` +
                    `ORDER BY iso_eventtime;`,
                'action': 'RUN',
                'type': 'SQLv1',
            },
            headers: {
                'Authorization': `OAuth ${token}`,
            },
        }).then(response => {
            this.setState({
                response,
                error: null,
                isLoading: false,
            });
        }).catch(error => {
            this.setState({ error, isLoading: false });
        });
    }

    componentDidMount() {
        this.props.request?.reqid && this.getData();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        const { onClose } = this.props;
        const id = this.state.response?.id;
        const link = `https://yql-beta.yandex-team.ru/Operations/${id}`;

        return <Window title={'Запрос в YQL'} onClose={onClose.bind(null)} error={this.state.error}>
            {
                this.state.isLoading && <Spin/>
            }
            {
                id && <Link href={link} target={'_blank'}>{link}</Link>
            }
        </Window>;
    }
}
