import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS = {
    GET_REQUESTS: 'GET_REQUESTS',
    GET_TOKEN: 'GET_TOKEN',
    CREAT_QYERY: 'CREAT_QYERY',
};

export const USER_ACTIONS_VIEW_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_REQUESTS]: {
        api: 'user/requests',
        cgiObj: {
            user_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_TOKEN]: {
        apiPrefix: API_PREFIXES.YQL,
        api: 'interactive_token',
    },

    [REQUESTS.CREAT_QYERY]: {
        apiPrefix: API_PREFIXES.YQL,
        api: 'api/v2/operations',
        method: REQUEST_METHOD.POST,
    },
};
