import React from 'react';

import { ONE_SECOND } from '../../../../../constants';
import { FormatDateInString } from '../../../../../ui/FormatDate';
import style from '../index.css';
import { IDrivingAchievements } from '../types';

interface IDrivingAchievementsProps {
    achievements: IDrivingAchievements[];
}

export const DrivingAchievements = React.memo((props: IDrivingAchievementsProps) => {
    const { achievements } = props;

    return <div>
        <h2>Ачивки</h2>

        <div className={style.achievements}>
            {achievements.map(item => {
                const date = item.last_level_ts
                    ? FormatDateInString({ value: item.last_level_ts * ONE_SECOND, onlyDate: true })
                    : '';

                return <div key={item.name} className={style.item}>
                    <img src={item.image} alt={item.title} className={style.img}/>
                    <div className={style.title}>{item.title}</div>
                    <div className={style.subtitle}>{item.sub_title}</div>
                    <div className={style.subtitle}>{date}</div>

                    {item.level
                        ? <div className={style.level}>{item.level}</div>
                        : null
                    }
                </div>;
            })}
        </div>
    </div>;
});
