export interface IDrivingProfile {
    achievements: IDrivingAchievements[];
    driving_style: IDrivingStyle;
}

export interface IDrivingStyle {
    notifications: {
        bg_color: string;
        buttons: {
            link: string;
            title: string;
        }[];
        type: string;
        details: {
            cashback: string;
            subtitle: string;
            description: string;
            title: string;
        };
        icon: string;
        description: string;
        title: string;
    }[];
    last_change: {
        direction: number;
        title: string;
    };
    update_ts: number;
    items: IDrivingStyleItem[];
    sessions: {
        filter: string;
        profile_filter: string;
        title: string;
    };
    button: {
        deeplink: string;
        title: string;
    };
}

export interface IDrivingStyleItem {
    caption: string;
    descriptions: {
        items: {
            icon: string;
            text: string;
        }[];
        title: string;
    };
    id: string;
    next_value: number;
    prev_value: number;
    value: number;
    parts?: number;
    next_color: string;
    notification_title: string;
    notifications: {
        bg_color: string;
        buttons: {
            link: string;
            title: string;
        }[];
        type: string;
        details: {
            cashback: string;
            subtitle: string;
            description: string;
            title: string;
        };
        icon: string;
        description: string;
        title: string;
    }[];
    prev_color: string;
    sub_caption: string;
    focused: boolean;
}

export interface IDrivingAchievements {
    gradient_color: string[];
    image: string;
    name: string;
    progress: number;
    progress_title: string;
    progress_value_color: string;
    sub_title: string;
    title: string;
    level?: number;
    last_level_ts?: number;
}
