import * as React from 'react';

import { Window } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import { isObjectEqual } from '../../../../utils/isObjectEqual';
import { Request2 } from '../../../../utils/request';
import { deepCopy } from '../../../../utils/utils';
import { CLIENTS_CARD_REQUESTS, REQUESTS } from '../../request';
import { UserCurrentTagList } from '../../UserInfoView/UserCurrentTagList';
import * as style_common from '../index.css';
import * as style from './index.css';

interface IUserSidebarTagsProps {
    userInfo: any;
    aggregateTags?: any;
    tags?: any[];
}

interface IUserSidebarTagsState {
    aggregatedResult: Record<string, any>;
    showTagsData: any;
    tagsDataIsShowing: boolean;
}

export class UserSidebarTags extends React.Component<IUserSidebarTagsProps, IUserSidebarTagsState> {
    state: IUserSidebarTagsState = {
        aggregatedResult: {},
        showTagsData: null,
        tagsDataIsShowing: false,
    };

    request = new Request2({ requestConfigs: CLIENTS_CARD_REQUESTS });

    shouldComponentUpdate(
        nextProps: Readonly<IUserSidebarTagsProps>,
        nextState: Readonly<IUserSidebarTagsState>,
        nextContext: any,
    ): boolean {
        return !isObjectEqual(this.props, nextProps) || !isObjectEqual(this.state, nextState);
    }

    getData() {
        const { userInfo, tags } = this.props;
        const aggregateTags = deepCopy(this.props.aggregateTags) ?? [];
        (
            tags && Promise.resolve({ records: tags })
            || userInfo.id && this.request.exec(REQUESTS.GET_USER_TAGS, { queryParams: { object_id: userInfo.id } })
        ).then((userTags) => {
            const aggregatedResult = aggregateTags?.reduce((_p: any, _c: any) => {
                if (!_p.hasOwnProperty(_c.alias)) {
                    _p[_c.alias] = {};
                }

                _c.count = 0;
                _p[_c.alias] = _c;

                return _p;
            }, {});

            userTags?.records?.forEach((_tag: any) => {
                Object.entries(aggregatedResult).map((_el: any) => {
                    if (_el[1]?.tags?.includes(_tag.tag) && aggregatedResult[_el[0]]) {
                        aggregatedResult[_el[0]].count = aggregatedResult[_el[0]].count + 1;
                        if (!aggregatedResult[_el[0]].hasOwnProperty('_tags')) {
                            aggregatedResult[_el[0]]._tags = [];
                        }

                        aggregatedResult[_el[0]]._tags.push(_tag);
                    }
                });
            });

            this.setState({
                aggregatedResult,
            });
        });
    }

    showTags(data: any) {
        this.setState({
            showTagsData: data,
            tagsDataIsShowing: true,
        });
    }

    closeTagsData() {
        this.setState({
            showTagsData: null,
            tagsDataIsShowing: false,
        });
    }

    componentDidMount(): void {
        this.getData();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    componentDidUpdate(prevProps: Readonly<IUserSidebarTagsProps>) {
        const { userInfo, tags } = this.props;
        if (prevProps.userInfo?.id !== userInfo?.id || !isObjectEqual(tags, prevProps.tags)) {
            this.getData();
        }
    }

    render() {
        const { aggregatedResult, showTagsData, tagsDataIsShowing } = this.state;

        return (
            <>
                {tagsDataIsShowing && (
                    <Window onClose={this.closeTagsData.bind(this)}
                            title={showTagsData?.[0]?.display_name ?? showTagsData?.[0]?.tag ?? showTagsData[0]}>
                        <div className={style.show_user_tags}>
                            <UserCurrentTagList data={showTagsData?.[1]?._tags ?? showTagsData}/>
                        </div>
                    </Window>
                )}
                <div className={style_common.blackbox}>
                    <div className={style_common.blackbox_item_title}>
                        ТЕГИ
                    </div>
                    <div className={style_common.blackbox}>
                        {
                            Object.entries(aggregatedResult)
                                .map((_el: any, index: number) => {
                                    return _el[1].count
                                        && <UserTag key={`${_el.tag}_${index}`}
                                                    data={_el}
                                                    onClick={this.showTags.bind(this)}
                                                    name={`${_el[0]} (${_el[1].count})`}
                                                    backgroundColor={_el[1].color}
                                                    className={style[_el[1].type]}/> || null;
                                })
                        }
                    </div>
                </div>
            </>
        );
    }
}

export const UserTag = ({ name, deleteTag, className, data, onClick, backgroundColor }: any) => {
    return (
        <div className={`${style.user_tag_item} ${!backgroundColor && className || ''}`}
             onClick={onClick && onClick.bind(null, data)}
             style={{ backgroundColor: backgroundColor }}>
            {name}
            {deleteTag && (
                <Link className={style.delete_btn}
                      onClick={deleteTag.bind(null)}>
                    x
                </Link>
            )}
        </div>
    );
};
