import React from 'react';
import ReactTooltip from 'react-tooltip';

import { ITagsWithPropsExport, UserTags } from '../../../../decorators/UserTags';
import { EMPTY_DATA, LONGTERM_FEED_TAG } from '../../../constants';
import { Button, ButtonTypes } from '../../../ui/Button';
import { Link } from '../../../ui/Link';
import { LongtermFeedButton } from '../../../utils/getLongtermFeedButton';
import { buttonLocationDetails, buttonNameDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import ActiveChatsCounter from '../../ActiveChatsCounter';
import { IStore } from '../../App/store';
import DocForQueuePicker from '../../Documents/DocForQueuePicker';
import Spin from '../../Spin';
import BillingViewForceModal from '../BillingView/BillingViewForceModal';
import ShortUserInfoBlock from '../ShortUserInfoBlock';
import UserFeaturesBlock from '../UserFeaturesBlock';
import UserIdentificationBlock from '../UserIdentificationBlock';
import * as style from './index.css';
import UserBanHistory from './UserBanHistory';
import UserSidebarTags from './UserSidebarTags';

interface IUserCardSidebarProps extends IStore, ITagsWithPropsExport {
    userInfo: any;
    isLoading?: boolean;
    aggregateTags?: any;
}

interface IUserCardSidebarState {
    [x: string]: boolean | any[];

    isDocsQueuePickerOpen: boolean;
    isBanHistoryOpen: boolean;
}

@UserTags()
export class UserCardSidebar extends React.Component<IUserCardSidebarProps, IUserCardSidebarState> {

    state: IUserCardSidebarState = {
        isDocsQueuePickerOpen: false,
        isBanHistoryOpen: false,
    };

    openModal(key: string) {
        this.setState({ [key]: true });
    }

    closeModal(key: string) {
        this.setState({ [key]: false });
    }

    componentDidMount() {
        this.props?.getTags?.({ object_id: this.props?.userInfo?.id });
    }

    componentDidUpdate(
        prevProps: Readonly<IUserCardSidebarProps>,
        prevState: Readonly<IUserCardSidebarState>,
        snapshot?: any,
    ) {
        if (this.props?.userInfo?.id !== prevProps.userInfo?.id) {
            this.props?.getTags?.({ object_id: this.props?.userInfo?.id });
        }
    }

    render() {
        const longtermFeedTag = this.props.tags?.find(el => el.tag === LONGTERM_FEED_TAG);

        return <div className={style.component}>
            {
                this.props.isLoading ? <Spin size={'s'}/>
                    : <>
                        <ShortUserInfoBlock userInfo={this.props.userInfo}
                                            tags={this.props.tags}/>
                        <ActiveChatsCounter tags={this.props.tags}
                                            isLoading={this.props.tagIsLoading}
                                            user_id={this.props.userInfo?.id}/>
                        <LongtermFeedButton tag={longtermFeedTag} className={style.longterm_link}/>
                        <SaasBlackbox userInfo={this.props.userInfo} blockRules={this.props.AdminUser?.blockRules}/>
                        <Withdrawals userInfo={this.props.userInfo}/>
                        <UserSidebarTags userInfo={this.props.userInfo} tags={this.props.tags}/>
                        <div className={style.button_container}>
                            {
                                this.props.AdminUser
                                && this.props.AdminUser.blockRules
                                && this.props.AdminUser.blockRules.Checking
                                    ? <Button colorType={ButtonTypes.warning}
                                              onClick={this.openModal.bind(this, 'isDocsQueuePickerOpen')}
                                              ytLog={{
                                                  button_name: buttonNameDetails.SHOW_DOCUMENTS,
                                                  location: buttonLocationDetails.CLIENT_CARD,
                                              }}>Документы</Button>
                                    : null
                            }
                            <Button ytLog={{
                                button_name: buttonNameDetails.BAN_HISTORY,
                                location: buttonLocationDetails.CLIENT_CARD,
                            }}
                                    onClick={this.openModal.bind(this, 'isBanHistoryOpen')}
                                    basic>Блокировки</Button>
                        </div>
                        <UserFeaturesBlock user_id={this.props.userInfo?.id}/>
                        <UserIdentificationBlock user_id={this.props.userInfo?.id}/>

                        {this.state.isDocsQueuePickerOpen
                            ? <DocForQueuePicker initValues={{ user_id: this.props.userInfo && this.props.userInfo.id }}
                                                 onClose={this.closeModal.bind(this, 'isDocsQueuePickerOpen')}/>
                            : null}
                        {this.state.isBanHistoryOpen
                            ? <UserBanHistory onClose={this.closeModal.bind(this, 'isBanHistoryOpen')}
                                              userInfo={this.props.userInfo}/>
                            : null}
                    </>
            }
        </div>;
    }
}

export const SaasBlackbox = React.memo((props: { userInfo: any; blockRules: any }) => {
    const { blackbox, social } = props.userInfo;

    const isPhonishExists = blackbox?.hasOwnProperty('phonish');

    return <div className={style.blackbox}>
        <div className={style.blackbox_item_title}>Яндекс.ПАСПОРТ</div>
        {blackbox && Object.keys(blackbox).length ? <div>
            {props.blockRules?.UserLogin
                ? <div className={style.blackbox_item}>ИМЯ: <span>{blackbox.public_name}</span></div>
                : ''}
            <div className={style.blackbox_item}>Яндексоид: <span>{blackbox.yandexoid ? 'ДА' : 'нет'}</span></div>
            <div className={style.blackbox_item}>Телефонный аккаунт: <span>
                {isPhonishExists ? (blackbox.phonish ? 'ДА' : 'нет') : EMPTY_DATA}
            </span>
            </div>
            <div className={style.blackbox_item}>Я.Плюс: <span>{blackbox.plus ? 'ДА' : 'нет'}</span></div>
            <div className={style.blackbox_item}>ПДД: <span>{blackbox.hosted
                && blackbox.hosted.is_hosted ? blackbox.hosted.domain : 'нет'}</span></div>
        </div>
            : EMPTY_DATA
        }
        <div className={style.blackbox_item_title}>СОЦ.СЕТИ:</div>
        {
            social
            && social.profiles
            && Array.isArray(social.profiles)
            && social.profiles.map((item: any, index: number) => {
                return <div key={index}>
                    {
                        item.addresses && item.addresses[0]
                            ? <Link href={item.addresses && item.addresses[0]} target={'_blank'}>{item.provider}</Link>
                            : item.provider
                    }
                    {item.username && <span> ({item.username})</span>}
                </div>;
            })
            || EMPTY_DATA
        }
        {blackbox?.social && <>
            <div className={`${style.blackbox_item_title} ${style.blackbox_soc_acc}`}>СОЦ.АКК:</div>
            {
                blackbox?.social_auth?.hr_soc_provider || blackbox?.soc_provuder
            }: <strong>{
                blackbox?.social_auth?.name
            }</strong>
        </>
        }
    </div>;
});

const Withdrawals = React.memo((props: { userInfo: any }) => {
    const { billing = {}, id } = props.userInfo;
    const [forceModal, openForceModal] = React.useState(false);

    return (
        <div className={style.blackbox}>
            <div className={style.blackbox_item_title}>
                СПИСАНИЯ
            </div>
            <div className={style.blackbox_item}>
                перезапущенных: {billing.forsed_tasks_count || EMPTY_DATA}
            </div>
            <div className={style.blackbox_item}
                 data-tip
                 data-for={'problem-item'}>
                зависших: {billing.tasks_count && (
                    <Link onClick={openForceModal.bind(null, true)}>
                        {billing.tasks_count}
                    </Link>
                )}

            </div>
            <ReactTooltip id={'problem-item'}
                          place={'top'}>
                {billing?.statuses?.map((item: any, index: number) => <div key={index}>{item}</div>)}
            </ReactTooltip>
            {forceModal && (
                <BillingViewForceModal user_id={id}
                                       session_id={''}
                                       onClose={openForceModal.bind(null, false)}
                                       reloadData={() => undefined}/>
            )}
        </div>
    );
});
