import React from 'react';

import { NoInformation } from '../../../../../ui/NoInformation';
import style from './index.css';

interface IFeatureBlockProps {
    title: string;
    data: Record<string, string | number> | null;
    filterValue: string;
}

export const FeatureBlock = (props: IFeatureBlockProps) => {
    const { title, data, filterValue } = props;
    let itemsArray;

    if(data) {
        itemsArray = Object.entries(data).filter(el =>
            el[0].toLocaleLowerCase().includes(filterValue.toLocaleLowerCase().trim()),
        );
    }

    return (
        <div>
            <h3 className={style.title}>{title}</h3>
            <div className={style.listContainer}>
                {
                    itemsArray?.map(el => {
                        const [key, value] = el;

                        return <React.Fragment key={key}>
                            <span>{key}</span>
                            <span>{value}</span>
                        </React.Fragment>;
                    },
                    )
                }
            </div>
            {
                !itemsArray?.length && <NoInformation />
            }
        </div>
    );
};
